/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eventbus.impl;

import com.netflix.eventbus.utils.EventBusUtils;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.StatsTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventBusStats {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBusStats.class);
    final StatsTimer publishStats;
    final StatsTimer conditionalPublishStats;
    final StatsTimer filterStats;
    final Counter publishErrors;
    final Counter conditionalPublishErrors;

    public EventBusStats(long collectionDurationInMillis) {
        this.publishStats = EventBusUtils.newStatsTimer("eventbus_publish", collectionDurationInMillis);
        this.conditionalPublishStats = EventBusUtils.newStatsTimer("eventbus_conditional_publish", collectionDurationInMillis);
        this.filterStats = EventBusUtils.newStatsTimer("eventbus_publish_filter_stats", collectionDurationInMillis);
        this.publishErrors = new BasicCounter(MonitorConfig.builder("eventbus_publish_errors").build());
        this.conditionalPublishErrors = new BasicCounter(MonitorConfig.builder("eventbus_conditional_publish_errors").build());
        try {
            Monitors.registerObject(this);
        }
        catch (Throwable th) {
            LOGGER.error("Unable to register to event bus stats to servo.", th);
        }
    }
}

