/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import com.netflix.eureka.Version;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.CurrentRequestVersion;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/xml", "application/json"})
@Path(value="/{version}/instances")
public class InstancesResource {
    private static final Logger logger = LoggerFactory.getLogger(InstancesResource.class);
    private final PeerAwareInstanceRegistry registry;

    @Inject
    InstancesResource(EurekaServerContext server) {
        this.registry = server.getRegistry();
    }

    public InstancesResource() {
        this(EurekaServerContextHolder.getInstance().getServerContext());
    }

    @GET
    @Path(value="{id}")
    public Response getById(@PathParam(value="version") String version, @PathParam(value="id") String id) {
        CurrentRequestVersion.set(Version.toEnum(version));
        List<InstanceInfo> list = this.registry.getInstancesById(id);
        CurrentRequestVersion.remove();
        if (list != null && !list.isEmpty()) {
            return Response.ok(list.get(0)).build();
        }
        logger.info("Not Found: {}", (Object)id);
        return Response.status(Response.Status.NOT_FOUND).build();
    }
}

