/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.resolver.aws;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.resolver.ClusterResolver;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.resolver.ResolverUtils;
import com.netflix.discovery.shared.resolver.aws.AwsEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpClientFactory;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.shared.transport.EurekaTransportConfig;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.decorator.RetryableEurekaHttpClient;
import com.netflix.discovery.shared.transport.decorator.ServerStatusEvaluators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaHttpResolver
implements ClusterResolver<AwsEndpoint> {
    private static final Logger logger = LoggerFactory.getLogger(EurekaHttpResolver.class);
    private final EurekaClientConfig clientConfig;
    private final EurekaTransportConfig transportConfig;
    private final String vipAddress;
    private final EurekaHttpClientFactory clientFactory;

    public EurekaHttpResolver(EurekaClientConfig clientConfig, EurekaTransportConfig transportConfig, ClusterResolver<EurekaEndpoint> bootstrapResolver, TransportClientFactory transportClientFactory, String vipAddress) {
        this(clientConfig, transportConfig, RetryableEurekaHttpClient.createFactory("resolver", transportConfig, bootstrapResolver, transportClientFactory, ServerStatusEvaluators.httpSuccessEvaluator()), vipAddress);
    }

    EurekaHttpResolver(EurekaClientConfig clientConfig, EurekaTransportConfig transportConfig, EurekaHttpClientFactory clientFactory, String vipAddress) {
        this.clientConfig = clientConfig;
        this.transportConfig = transportConfig;
        this.clientFactory = clientFactory;
        this.vipAddress = vipAddress;
    }

    @Override
    public String getRegion() {
        return this.clientConfig.getRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AwsEndpoint> getClusterEndpoints() {
        ArrayList<AwsEndpoint> result = new ArrayList<AwsEndpoint>();
        EurekaHttpClient client = null;
        try {
            Applications applications;
            client = this.clientFactory.newClient();
            EurekaHttpResponse<Applications> response = client.getVip(this.vipAddress, new String[0]);
            if (this.validResponse(response) && (applications = response.getEntity()) != null) {
                applications.shuffleInstances(true);
                List<InstanceInfo> validInstanceInfos = applications.getInstancesByVirtualHostName(this.vipAddress);
                for (InstanceInfo instanceInfo : validInstanceInfos) {
                    AwsEndpoint endpoint = ResolverUtils.instanceInfoToEndpoint(this.clientConfig, this.transportConfig, instanceInfo);
                    if (endpoint == null) continue;
                    result.add(endpoint);
                }
                logger.debug("Retrieved endpoint list {}", (Object)result);
                ArrayList<AwsEndpoint> arrayList = result;
                return arrayList;
            }
        }
        catch (Exception e) {
            logger.error("Error contacting server for endpoints with vipAddress:{}", (Object)this.vipAddress, (Object)e);
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
        logger.info("Returning empty endpoint list");
        return Collections.emptyList();
    }

    private <T> boolean validResponse(EurekaHttpResponse<T> response) {
        if (response == null) {
            return false;
        }
        int responseCode = response.getStatusCode();
        return responseCode >= 200 && responseCode < 300;
    }
}

