/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.converters.KeyFormatter;
import com.netflix.discovery.converters.jackson.AbstractEurekaJacksonCodec;
import com.netflix.discovery.converters.jackson.EurekaJacksonJsonModifiers;
import com.netflix.discovery.converters.jackson.mixin.ApplicationsJsonMixIn;
import com.netflix.discovery.converters.jackson.mixin.InstanceInfoJsonMixIn;
import com.netflix.discovery.shared.Applications;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EurekaJsonJacksonCodec
extends AbstractEurekaJacksonCodec {
    private final ObjectMapper wrappedJsonMapper;
    private final ObjectMapper unwrappedJsonMapper;
    private final Map<Class<?>, ObjectMapper> mappers = new ConcurrentHashMap();

    public EurekaJsonJacksonCodec() {
        this(KeyFormatter.defaultKeyFormatter(), false);
    }

    public EurekaJsonJacksonCodec(KeyFormatter keyFormatter, boolean compact) {
        this.unwrappedJsonMapper = this.createObjectMapper(keyFormatter, compact, false);
        this.wrappedJsonMapper = this.createObjectMapper(keyFormatter, compact, true);
    }

    private ObjectMapper createObjectMapper(KeyFormatter keyFormatter, boolean compact, boolean wrapped) {
        ObjectMapper newMapper = new ObjectMapper();
        SimpleModule jsonModule = new SimpleModule();
        jsonModule.setSerializerModifier(EurekaJacksonJsonModifiers.createJsonSerializerModifier(keyFormatter, compact));
        newMapper.registerModule(jsonModule);
        newMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        newMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, wrapped);
        newMapper.configure(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED, false);
        newMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, wrapped);
        newMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        newMapper.addMixIn(Applications.class, ApplicationsJsonMixIn.class);
        if (compact) {
            this.addMiniConfig(newMapper);
        } else {
            newMapper.addMixIn(InstanceInfo.class, InstanceInfoJsonMixIn.class);
        }
        return newMapper;
    }

    @Override
    public <T> ObjectMapper getObjectMapper(Class<T> type) {
        ObjectMapper mapper = this.mappers.get(type);
        if (mapper == null) {
            mapper = EurekaJsonJacksonCodec.hasJsonRootName(type) ? this.wrappedJsonMapper : this.unwrappedJsonMapper;
            this.mappers.put(type, mapper);
        }
        return mapper;
    }
}

