/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.thoughtworks.xstream.annotations.XStreamOmitField;

@JsonRootName(value="leaseInfo")
public class LeaseInfo {
    public static final int DEFAULT_LEASE_RENEWAL_INTERVAL = 30;
    public static final int DEFAULT_LEASE_DURATION = 90;
    private int renewalIntervalInSecs = 30;
    private int durationInSecs = 90;
    private long registrationTimestamp;
    private long lastRenewalTimestamp;
    private long evictionTimestamp;
    private long serviceUpTimestamp;

    private LeaseInfo() {
    }

    @JsonCreator
    public LeaseInfo(@JsonProperty(value="renewalIntervalInSecs") int renewalIntervalInSecs, @JsonProperty(value="durationInSecs") int durationInSecs, @JsonProperty(value="registrationTimestamp") long registrationTimestamp, @JsonProperty(value="lastRenewalTimestamp") Long lastRenewalTimestamp, @JsonProperty(value="renewalTimestamp") long lastRenewalTimestampLegacy, @JsonProperty(value="evictionTimestamp") long evictionTimestamp, @JsonProperty(value="serviceUpTimestamp") long serviceUpTimestamp) {
        this.renewalIntervalInSecs = renewalIntervalInSecs;
        this.durationInSecs = durationInSecs;
        this.registrationTimestamp = registrationTimestamp;
        this.evictionTimestamp = evictionTimestamp;
        this.serviceUpTimestamp = serviceUpTimestamp;
        this.lastRenewalTimestamp = lastRenewalTimestamp == null ? lastRenewalTimestampLegacy : lastRenewalTimestamp;
    }

    public long getRegistrationTimestamp() {
        return this.registrationTimestamp;
    }

    @JsonProperty(value="lastRenewalTimestamp")
    public long getRenewalTimestamp() {
        return this.lastRenewalTimestamp;
    }

    public long getEvictionTimestamp() {
        return this.evictionTimestamp;
    }

    public long getServiceUpTimestamp() {
        return this.serviceUpTimestamp;
    }

    public int getRenewalIntervalInSecs() {
        return this.renewalIntervalInSecs;
    }

    public int getDurationInSecs() {
        return this.durationInSecs;
    }

    public static final class Builder {
        @XStreamOmitField
        private LeaseInfo result = new LeaseInfo();

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder setRegistrationTimestamp(long ts) {
            this.result.registrationTimestamp = ts;
            return this;
        }

        public Builder setRenewalTimestamp(long ts) {
            this.result.lastRenewalTimestamp = ts;
            return this;
        }

        public Builder setEvictionTimestamp(long ts) {
            this.result.evictionTimestamp = ts;
            return this;
        }

        public Builder setServiceUpTimestamp(long ts) {
            this.result.serviceUpTimestamp = ts;
            return this;
        }

        public Builder setDurationInSecs(int d) {
            if (d <= 0) {
                this.result.durationInSecs = 90;
            } else {
                this.result.durationInSecs = d;
            }
            return this;
        }

        public Builder setRenewalIntervalInSecs(int i2) {
            if (i2 <= 0) {
                this.result.renewalIntervalInSecs = 30;
            } else {
                this.result.renewalIntervalInSecs = i2;
            }
            return this;
        }

        public LeaseInfo build() {
            return this.result;
        }
    }
}

