/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.AmazonInfoConfig;
import com.netflix.appinfo.Archaius1AmazonInfoConfig;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.PropertiesInstanceConfig;
import com.netflix.appinfo.RefreshableAmazonInfoProvider;
import com.netflix.appinfo.RefreshableInstanceConfig;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CloudInstanceConfig
extends PropertiesInstanceConfig
implements RefreshableInstanceConfig {
    private static final Logger logger = LoggerFactory.getLogger(CloudInstanceConfig.class);
    private static final String[] DEFAULT_AWS_ADDRESS_RESOLUTION_ORDER = new String[]{AmazonInfo.MetaDataKey.publicHostname.name(), AmazonInfo.MetaDataKey.localIpv4.name()};
    private final RefreshableAmazonInfoProvider amazonInfoHolder;

    public CloudInstanceConfig() {
        this("eureka");
    }

    public CloudInstanceConfig(String namespace) {
        this(namespace, new Archaius1AmazonInfoConfig(namespace), null, true);
    }

    CloudInstanceConfig(AmazonInfo info) {
        this("eureka", new Archaius1AmazonInfoConfig("eureka"), info, false);
    }

    CloudInstanceConfig(String namespace, RefreshableAmazonInfoProvider refreshableAmazonInfoProvider) {
        super(namespace);
        this.amazonInfoHolder = refreshableAmazonInfoProvider;
    }

    CloudInstanceConfig(String namespace, AmazonInfoConfig amazonInfoConfig, AmazonInfo initialInfo, boolean eagerInit) {
        super(namespace);
        if (eagerInit) {
            RefreshableAmazonInfoProvider.FallbackAddressProvider fallbackAddressProvider = new RefreshableAmazonInfoProvider.FallbackAddressProvider(){

                @Override
                public String getFallbackIp() {
                    return CloudInstanceConfig.super.getIpAddress();
                }

                @Override
                public String getFallbackHostname() {
                    return CloudInstanceConfig.super.getHostName(false);
                }
            };
            this.amazonInfoHolder = new RefreshableAmazonInfoProvider(amazonInfoConfig, fallbackAddressProvider);
        } else {
            this.amazonInfoHolder = new RefreshableAmazonInfoProvider(initialInfo, amazonInfoConfig);
        }
    }

    @Deprecated
    public String resolveDefaultAddress() {
        return this.resolveDefaultAddress(true);
    }

    @Override
    public String resolveDefaultAddress(boolean refresh) {
        String result = this.getHostName(refresh);
        for (String name : this.getDefaultAddressResolutionOrder()) {
            try {
                AmazonInfo.MetaDataKey key = AmazonInfo.MetaDataKey.valueOf(name);
                String address = this.amazonInfoHolder.get().get(key);
                if (address == null || address.isEmpty()) continue;
                result = address;
                break;
            }
            catch (Exception e) {
                logger.error("failed to resolve default address for key {}, skipping", (Object)name, (Object)e);
            }
        }
        return result;
    }

    @Override
    public String getHostName(boolean refresh) {
        if (refresh) {
            this.amazonInfoHolder.refresh();
        }
        return this.amazonInfoHolder.get().get(AmazonInfo.MetaDataKey.publicHostname);
    }

    @Override
    public String getIpAddress() {
        return this.shouldBroadcastPublicIpv4Addr() ? this.getPublicIpv4Addr() : this.getPrivateIpv4Addr();
    }

    private String getPrivateIpv4Addr() {
        String privateIpv4Addr = this.amazonInfoHolder.get().get(AmazonInfo.MetaDataKey.localIpv4);
        return privateIpv4Addr == null ? super.getIpAddress() : privateIpv4Addr;
    }

    private String getPublicIpv4Addr() {
        String publicIpv4Addr = this.amazonInfoHolder.get().get(AmazonInfo.MetaDataKey.publicIpv4);
        return publicIpv4Addr == null ? super.getIpAddress() : publicIpv4Addr;
    }

    @Override
    public DataCenterInfo getDataCenterInfo() {
        return this.amazonInfoHolder.get();
    }

    @Override
    public String[] getDefaultAddressResolutionOrder() {
        String[] order = super.getDefaultAddressResolutionOrder();
        return order.length == 0 ? DEFAULT_AWS_ADDRESS_RESOLUTION_ORDER : order;
    }

    @Deprecated
    public synchronized void refreshAmazonInfo() {
        this.amazonInfoHolder.refresh();
    }

    @Deprecated
    static boolean shouldUpdate(AmazonInfo newInfo, AmazonInfo oldInfo) {
        return RefreshableAmazonInfoProvider.shouldUpdate(newInfo, oldInfo);
    }
}

