/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.util;

import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;

public final class ProxyUtils {
    private ProxyUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static <T> T getTargetObject(Object candidate) {
        Assert.notNull(candidate, "Candidate must not be null");
        try {
            Object target;
            if (AopUtils.isAopProxy(candidate) && candidate instanceof Advised && (target = ((Advised)candidate).getTargetSource().getTarget()) != null) {
                return ProxyUtils.getTargetObject(target);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return (T)candidate;
    }
}

