/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.serviceregistry;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.transport.jersey.TransportClientFactories;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.netflix.eureka.CloudEurekaClient;
import org.springframework.cloud.netflix.eureka.CloudEurekaInstanceConfig;
import org.springframework.cloud.netflix.eureka.InstanceInfoFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.Assert;

public class EurekaRegistration
implements Registration {
    private static final Log log = LogFactory.getLog(EurekaRegistration.class);
    private final EurekaClient eurekaClient;
    private final AtomicReference<CloudEurekaClient> cloudEurekaClient = new AtomicReference();
    private final CloudEurekaInstanceConfig instanceConfig;
    private final ApplicationInfoManager applicationInfoManager;
    private ObjectProvider<HealthCheckHandler> healthCheckHandler;

    public EurekaRegistration(CloudEurekaInstanceConfig instanceConfig, EurekaClient eurekaClient, ApplicationInfoManager applicationInfoManager, ObjectProvider<HealthCheckHandler> healthCheckHandler) {
        this.eurekaClient = eurekaClient;
        this.instanceConfig = instanceConfig;
        this.applicationInfoManager = applicationInfoManager;
        this.healthCheckHandler = healthCheckHandler;
    }

    public static Builder builder(CloudEurekaInstanceConfig instanceConfig) {
        return new Builder(instanceConfig);
    }

    @Override
    public String getInstanceId() {
        return this.instanceConfig.getInstanceId();
    }

    @Override
    public String getServiceId() {
        return this.instanceConfig.getAppname();
    }

    @Override
    public String getHost() {
        return this.instanceConfig.getHostName(false);
    }

    @Override
    public int getPort() {
        if (this.instanceConfig.getSecurePortEnabled()) {
            return this.instanceConfig.getSecurePort();
        }
        return this.instanceConfig.getNonSecurePort();
    }

    @Override
    public boolean isSecure() {
        return this.instanceConfig.getSecurePortEnabled();
    }

    @Override
    public URI getUri() {
        return DefaultServiceInstance.getUri(this);
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.instanceConfig.getMetadataMap();
    }

    public CloudEurekaClient getEurekaClient() {
        if (this.cloudEurekaClient.get() == null) {
            try {
                this.cloudEurekaClient.compareAndSet(null, this.getTargetObject(this.eurekaClient, CloudEurekaClient.class));
            }
            catch (Exception e) {
                log.error("error getting CloudEurekaClient", e);
            }
        }
        return this.cloudEurekaClient.get();
    }

    protected <T> T getTargetObject(Object proxy, Class<T> targetClass) throws Exception {
        if (AopUtils.isJdkDynamicProxy(proxy)) {
            return (T)((Advised)proxy).getTargetSource().getTarget();
        }
        return (T)proxy;
    }

    public CloudEurekaInstanceConfig getInstanceConfig() {
        return this.instanceConfig;
    }

    public ApplicationInfoManager getApplicationInfoManager() {
        return this.applicationInfoManager;
    }

    public ObjectProvider<HealthCheckHandler> getHealthCheckHandler() {
        return this.healthCheckHandler;
    }

    public void setHealthCheckHandler(ObjectProvider<HealthCheckHandler> healthCheckHandler) {
        this.healthCheckHandler = healthCheckHandler;
    }

    public void setNonSecurePort(int port) {
        this.instanceConfig.setNonSecurePort(port);
    }

    public int getNonSecurePort() {
        return this.instanceConfig.getNonSecurePort();
    }

    public void setSecurePort(int port) {
        this.instanceConfig.setSecurePort(port);
    }

    public int getSecurePort() {
        return this.instanceConfig.getSecurePort();
    }

    public static class Builder {
        private final CloudEurekaInstanceConfig instanceConfig;
        private ApplicationInfoManager applicationInfoManager;
        private EurekaClient eurekaClient;
        private ObjectProvider<HealthCheckHandler> healthCheckHandler;
        private EurekaClientConfig clientConfig;
        private ApplicationEventPublisher publisher;
        private TransportClientFactories<?> transportClientFactories;

        Builder(CloudEurekaInstanceConfig instanceConfig) {
            this.instanceConfig = instanceConfig;
        }

        public Builder with(ApplicationInfoManager applicationInfoManager) {
            this.applicationInfoManager = applicationInfoManager;
            return this;
        }

        public Builder with(EurekaClient eurekaClient) {
            this.eurekaClient = eurekaClient;
            return this;
        }

        public Builder with(ObjectProvider<HealthCheckHandler> healthCheckHandler) {
            this.healthCheckHandler = healthCheckHandler;
            return this;
        }

        public Builder with(TransportClientFactories<?> transportClientFactories) {
            this.transportClientFactories = transportClientFactories;
            return this;
        }

        public Builder with(EurekaClientConfig clientConfig, ApplicationEventPublisher publisher) {
            this.clientConfig = clientConfig;
            this.publisher = publisher;
            return this;
        }

        public EurekaRegistration build() {
            Assert.notNull((Object)this.instanceConfig, "instanceConfig may not be null");
            if (this.applicationInfoManager == null) {
                InstanceInfo instanceInfo = new InstanceInfoFactory().create(this.instanceConfig);
                this.applicationInfoManager = new ApplicationInfoManager((EurekaInstanceConfig)this.instanceConfig, instanceInfo);
            }
            if (this.eurekaClient == null) {
                Assert.notNull((Object)this.clientConfig, "if eurekaClient is null, EurekaClientConfig may not be null");
                Assert.notNull((Object)this.publisher, "if eurekaClient is null, ApplicationEventPublisher may not be null");
                Assert.notNull(this.transportClientFactories, "if eurekaClient is null, TransportClientFactories may not be null");
                this.eurekaClient = new CloudEurekaClient(this.applicationInfoManager, this.clientConfig, this.transportClientFactories, this.publisher);
            }
            return new EurekaRegistration(this.instanceConfig, this.eurekaClient, this.applicationInfoManager, this.healthCheckHandler);
        }
    }
}

