/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cloud.netflix.eureka.RestTemplateTimeoutProperties;
import org.springframework.cloud.netflix.eureka.http.EurekaClientHttpRequestFactorySupplier;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.lang.Nullable;

public class DefaultEurekaClientHttpRequestFactorySupplier
implements EurekaClientHttpRequestFactorySupplier,
DisposableBean {
    private final AtomicReference<CloseableHttpClient> ref = new AtomicReference();
    private final RestTemplateTimeoutProperties restTemplateTimeoutProperties;

    @Deprecated
    public DefaultEurekaClientHttpRequestFactorySupplier() {
        this.restTemplateTimeoutProperties = new RestTemplateTimeoutProperties();
    }

    public DefaultEurekaClientHttpRequestFactorySupplier(RestTemplateTimeoutProperties restTemplateTimeoutProperties) {
        this.restTemplateTimeoutProperties = restTemplateTimeoutProperties;
    }

    @Override
    public ClientHttpRequestFactory get(SSLContext sslContext, @Nullable HostnameVerifier hostnameVerifier) {
        TimeValue timeValue = this.restTemplateTimeoutProperties != null ? TimeValue.ofMilliseconds(this.restTemplateTimeoutProperties.getIdleTimeout()) : TimeValue.of(30L, TimeUnit.SECONDS);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().evictExpiredConnections().evictIdleConnections(timeValue);
        if (sslContext != null || hostnameVerifier != null || this.restTemplateTimeoutProperties != null) {
            httpClientBuilder.setConnectionManager(this.buildConnectionManager(sslContext, hostnameVerifier, this.restTemplateTimeoutProperties));
        }
        if (this.restTemplateTimeoutProperties != null) {
            httpClientBuilder.setDefaultRequestConfig(this.buildRequestConfig());
        }
        if (this.ref.get() == null) {
            this.ref.compareAndSet(null, httpClientBuilder.build());
        }
        CloseableHttpClient httpClient = this.ref.get();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient(httpClient);
        return requestFactory;
    }

    private HttpClientConnectionManager buildConnectionManager(SSLContext sslContext, HostnameVerifier hostnameVerifier, RestTemplateTimeoutProperties restTemplateTimeoutProperties) {
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        SSLConnectionSocketFactoryBuilder sslConnectionSocketFactoryBuilder = SSLConnectionSocketFactoryBuilder.create();
        if (sslContext != null) {
            sslConnectionSocketFactoryBuilder.setSslContext(sslContext);
        }
        if (hostnameVerifier != null) {
            sslConnectionSocketFactoryBuilder.setHostnameVerifier(hostnameVerifier);
        }
        connectionManagerBuilder.setSSLSocketFactory(sslConnectionSocketFactoryBuilder.build());
        if (restTemplateTimeoutProperties != null) {
            connectionManagerBuilder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.of(restTemplateTimeoutProperties.getSocketTimeout(), TimeUnit.MILLISECONDS)).build());
        }
        return connectionManagerBuilder.build();
    }

    private RequestConfig buildRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(Timeout.of(this.restTemplateTimeoutProperties.getConnectTimeout(), TimeUnit.MILLISECONDS)).setConnectionRequestTimeout(Timeout.of(this.restTemplateTimeoutProperties.getConnectRequestTimeout(), TimeUnit.MILLISECONDS)).build();
    }

    @Override
    public void destroy() throws Exception {
        CloseableHttpClient httpClient = this.ref.get();
        if (httpClient != null) {
            httpClient.close();
        }
    }
}

