/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.context.ApplicationListener;
import reactor.cache.CacheFlux;
import reactor.core.publisher.Flux;

public class CachingRouteDefinitionLocator
implements RouteDefinitionLocator,
ApplicationListener<RefreshRoutesEvent> {
    private static final String CACHE_KEY = "routeDefs";
    private final RouteDefinitionLocator delegate;
    private final Flux<RouteDefinition> routeDefinitions;
    private final Map<String, List> cache = new ConcurrentHashMap<String, List>();

    public CachingRouteDefinitionLocator(RouteDefinitionLocator delegate) {
        this.delegate = delegate;
        this.routeDefinitions = CacheFlux.lookup(this.cache, CACHE_KEY, RouteDefinition.class).onCacheMissResume(this::fetch);
    }

    private Flux<RouteDefinition> fetch() {
        return this.delegate.getRouteDefinitions();
    }

    @Override
    public Flux<RouteDefinition> getRouteDefinitions() {
        return this.routeDefinitions;
    }

    public Flux<RouteDefinition> refresh() {
        this.cache.clear();
        return this.routeDefinitions;
    }

    @Override
    public void onApplicationEvent(RefreshRoutesEvent event) {
        this.fetch().materialize().collect(Collectors.toList()).doOnNext(routes -> this.cache.put(CACHE_KEY, (List)routes)).subscribe();
    }
}

