/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import jakarta.validation.constraints.NotEmpty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.server.ServerWebExchange;

public class HeaderRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String HEADER_KEY = "header";
    public static final String REGEXP_KEY = "regexp";

    public HeaderRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(HEADER_KEY, REGEXP_KEY);
    }

    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        final Pattern pattern = StringUtils.hasText(config.regexp) ? Pattern.compile(config.regexp) : null;
        return new GatewayPredicate(){

            @Override
            public boolean test(ServerWebExchange exchange2) {
                List values = exchange2.getRequest().getHeaders().getOrDefault(config.header, Collections.emptyList());
                if (values.isEmpty()) {
                    return false;
                }
                if (pattern != null) {
                    for (int i2 = 0; i2 < values.size(); ++i2) {
                        String value = (String)values.get(i2);
                        if (!pattern.asMatchPredicate().test(value)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public Object getConfig() {
                return config;
            }

            public String toString() {
                return String.format("Header: %s regexp=%s", config.header, config.regexp);
            }
        };
    }

    @Validated
    public static class Config {
        @NotEmpty
        private String header;
        private String regexp;

        public String getHeader() {
            return this.header;
        }

        public Config setHeader(String header) {
            this.header = header;
            return this;
        }

        public String getRegexp() {
            return this.regexp;
        }

        public Config setRegexp(String regexp) {
            this.regexp = regexp;
            return this;
        }
    }
}

