/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.postprocessor;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.AfterCacheExchangeMutator;
import org.springframework.web.server.ServerWebExchange;

public class SetCacheDirectivesByMaxAgeAfterCacheExchangeMutator
implements AfterCacheExchangeMutator {
    final Pattern MAX_AGE_PATTERN = Pattern.compile("(?:,|^)\\s*max-age=(\\d+)");

    @Override
    public void accept(ServerWebExchange exchange2, CachedResponse cachedResponse) {
        Optional<Integer> maxAge = Optional.ofNullable(exchange2.getResponse().getHeaders().getCacheControl()).map(this.MAX_AGE_PATTERN::matcher).filter(Matcher::find).map(matcher -> matcher.group(1)).map(Integer::parseInt);
        if (maxAge.isPresent()) {
            if (maxAge.get() > 0) {
                this.removeNoCacheHeaders(exchange2);
            } else {
                this.keepNoCacheHeaders(exchange2);
            }
        }
    }

    private void keepNoCacheHeaders(ServerWebExchange exchange2) {
        String cacheControl = exchange2.getResponse().getHeaders().getCacheControl();
        StringBuilder newCacheControl = new StringBuilder(cacheControl);
        if (!cacheControl.contains("no-cache")) {
            newCacheControl.append(",no-cache");
        }
        if (!cacheControl.contains("must-revalidate")) {
            newCacheControl.append(",must-revalidate");
        }
        exchange2.getResponse().getHeaders().setCacheControl(newCacheControl.toString());
    }

    private void removeNoCacheHeaders(ServerWebExchange exchange2) {
        String cacheControl = exchange2.getResponse().getHeaders().getCacheControl();
        List<String> cacheControlValues = Arrays.asList(cacheControl.split("\\s*,\\s*"));
        String newCacheControl = cacheControlValues.stream().filter(s -> !s.matches("must-revalidate|no-cache|no-store")).collect(Collectors.joining(","));
        exchange2.getResponse().getHeaders().setCacheControl(newCacheControl);
    }
}

