/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheUtils;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheManager;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResponseCacheGatewayFilter
implements GatewayFilter,
Ordered {
    private final ResponseCacheManager responseCacheManager;

    public ResponseCacheGatewayFilter(ResponseCacheManager responseCacheManager) {
        this.responseCacheManager = responseCacheManager;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
        if (this.responseCacheManager.isRequestCacheable(exchange2.getRequest())) {
            exchange2.getAttributes().put("LocalResponseCacheGatewayFilter-Applied", true);
            return this.filterWithCache(exchange2, chain);
        }
        return chain.filter(exchange2);
    }

    @Override
    public int getOrder() {
        return -4;
    }

    private Mono<Void> filterWithCache(ServerWebExchange exchange2, GatewayFilterChain chain) {
        String metadataKey = this.responseCacheManager.resolveMetadataKey(exchange2);
        Optional<CachedResponse> cached = this.getCachedResponse(exchange2, metadataKey);
        if (cached.isPresent()) {
            return this.responseCacheManager.processFromCache(exchange2, metadataKey, cached.get());
        }
        return chain.filter(exchange2.mutate().response(new CachingResponseDecorator(metadataKey, exchange2)).build());
    }

    private Optional<CachedResponse> getCachedResponse(ServerWebExchange exchange2, String metadataKey) {
        Optional<CachedResponse> cached = this.shouldRevalidate(exchange2) ? Optional.empty() : this.responseCacheManager.getFromCache(exchange2.getRequest(), metadataKey);
        return cached;
    }

    private boolean shouldRevalidate(ServerWebExchange exchange2) {
        return LocalResponseCacheUtils.isNoCacheRequest(exchange2.getRequest());
    }

    private class CachingResponseDecorator
    extends ServerHttpResponseDecorator {
        private final String metadataKey;
        private final ServerWebExchange exchange;

        CachingResponseDecorator(String metadataKey, ServerWebExchange exchange2) {
            super(exchange2.getResponse());
            this.metadataKey = metadataKey;
            this.exchange = exchange2;
        }

        @Override
        public Mono<Void> writeWith(Publisher<? extends DataBuffer> body2) {
            ServerHttpResponse response = this.exchange.getResponse();
            Flux<? extends DataBuffer> decoratedBody = ResponseCacheGatewayFilter.this.responseCacheManager.isResponseCacheable(response) && !ResponseCacheGatewayFilter.this.responseCacheManager.isNoCacheRequestWithoutUpdate(this.exchange.getRequest()) ? ResponseCacheGatewayFilter.this.responseCacheManager.processFromUpstream(this.metadataKey, this.exchange, Flux.from(body2)) : Flux.from(body2);
            return super.writeWith(decoratedBody);
        }
    }
}

