/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.security.cert.X509Certificate;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.cloud.gateway.config.AbstractSslConfigurer;
import org.springframework.cloud.gateway.config.HttpClientProperties;
import reactor.netty.http.Http11SslContextSpec;
import reactor.netty.http.Http2SslContextSpec;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;
import reactor.netty.tcp.SslProvider;

public class HttpClientSslConfigurer
extends AbstractSslConfigurer<HttpClient, HttpClient> {
    private final ServerProperties serverProperties;

    public HttpClientSslConfigurer(HttpClientProperties.Ssl sslProperties, ServerProperties serverProperties) {
        super(sslProperties);
        this.serverProperties = serverProperties;
    }

    @Override
    public HttpClient configureSsl(HttpClient client) {
        HttpClientProperties.Ssl ssl = this.getSslProperties();
        if (ssl.getKeyStore() != null && ssl.getKeyStore().length() > 0 || this.getTrustedX509CertificatesForTrustManager().length > 0 || ssl.isUseInsecureTrustManager()) {
            client = client.secure(sslContextSpec -> this.configureSslContext(ssl, (SslProvider.SslContextSpec)sslContextSpec));
        }
        return client;
    }

    protected void configureSslContext(HttpClientProperties.Ssl ssl, SslProvider.SslContextSpec sslContextSpec) {
        AbstractProtocolSslContextSpec clientSslContext = this.serverProperties.getHttp2().isEnabled() ? Http2SslContextSpec.forClient() : Http11SslContextSpec.forClient();
        clientSslContext.configure(sslContextBuilder -> {
            X509Certificate[] trustedX509Certificates = this.getTrustedX509CertificatesForTrustManager();
            if (trustedX509Certificates.length > 0) {
                this.setTrustManager((SslContextBuilder)sslContextBuilder, trustedX509Certificates);
            } else if (ssl.isUseInsecureTrustManager()) {
                this.setTrustManager((SslContextBuilder)sslContextBuilder, InsecureTrustManagerFactory.INSTANCE);
            }
            try {
                sslContextBuilder.keyManager(this.getKeyManagerFactory());
            }
            catch (Exception e) {
                this.logger.error(e);
            }
        });
        sslContextSpec.sslContext(clientSslContext).handshakeTimeout(ssl.getHandshakeTimeout()).closeNotifyFlushTimeout(ssl.getCloseNotifyFlushTimeout()).closeNotifyReadTimeout(ssl.getCloseNotifyReadTimeout());
    }
}

