/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.core.style.ToStringCreator;

public class CompletionContext<RES, T, C> {
    private final Status status;
    private final Throwable throwable;
    private final Response<T> loadBalancerResponse;
    private final RES clientResponse;
    private final Request<C> loadBalancerRequest;

    public CompletionContext(Status status, Request<C> loadBalancerRequest) {
        this(status, null, loadBalancerRequest, null, null);
    }

    public CompletionContext(Status status, Request<C> loadBalancerRequest, Response<T> response) {
        this(status, null, loadBalancerRequest, response, null);
    }

    public CompletionContext(Status status, Throwable throwable, Request<C> loadBalancerRequest, Response<T> loadBalancerResponse) {
        this(status, throwable, loadBalancerRequest, loadBalancerResponse, null);
    }

    public CompletionContext(Status status, Request<C> loadBalancerRequest, Response<T> loadBalancerResponse, RES clientResponse) {
        this(status, null, loadBalancerRequest, loadBalancerResponse, clientResponse);
    }

    public CompletionContext(Status status, Throwable throwable, Request<C> loadBalancerRequest, Response<T> loadBalancerResponse, RES clientResponse) {
        this.status = status;
        this.throwable = throwable;
        this.loadBalancerRequest = loadBalancerRequest;
        this.loadBalancerResponse = loadBalancerResponse;
        this.clientResponse = clientResponse;
    }

    public Status status() {
        return this.status;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Response<T> getLoadBalancerResponse() {
        return this.loadBalancerResponse;
    }

    public RES getClientResponse() {
        return this.clientResponse;
    }

    public Request<C> getLoadBalancerRequest() {
        return this.loadBalancerRequest;
    }

    public String toString() {
        ToStringCreator to = new ToStringCreator(this);
        to.append("status", (Object)this.status);
        to.append("throwable", this.throwable);
        to.append("loadBalancerResponse", this.loadBalancerResponse);
        to.append("clientResponse", this.clientResponse);
        return to.toString();
    }

    public static enum Status {
        SUCCESS,
        FAILED,
        DISCARD;

    }
}

