/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={CommonsClientAutoConfiguration.class})
public class SimpleDiscoveryClientAutoConfiguration
implements ApplicationListener<WebServerInitializedEvent> {
    private ServerProperties server;
    private InetUtils inet;
    private int port = 0;
    private SimpleDiscoveryProperties simple = new SimpleDiscoveryProperties();

    @Autowired(required=false)
    public void setServer(ServerProperties server) {
        this.server = server;
    }

    @Autowired
    public void setInet(InetUtils inet) {
        this.inet = inet;
    }

    @Bean
    @ConditionalOnMissingBean
    public SimpleDiscoveryProperties simpleDiscoveryProperties(@Value(value="${spring.application.name:application}") String serviceId) {
        this.simple.getLocal().setServiceId(serviceId);
        this.simple.getLocal().setHost(this.inet.findFirstNonLoopbackHostInfo().getHostname());
        this.simple.getLocal().setPort(this.findPort());
        return this.simple;
    }

    @Bean
    @Order
    public DiscoveryClient simpleDiscoveryClient(SimpleDiscoveryProperties properties) {
        return new SimpleDiscoveryClient(properties);
    }

    private int findPort() {
        if (this.port > 0) {
            return this.port;
        }
        if (this.server != null && this.server.getPort() != null && this.server.getPort() > 0) {
            return this.server.getPort();
        }
        return 8080;
    }

    @Override
    public void onApplicationEvent(WebServerInitializedEvent webServerInitializedEvent) {
        this.port = webServerInitializedEvent.getWebServer().getPort();
        if (this.port > 0) {
            this.simple.getLocal().setHost(this.inet.findFirstNonLoopbackHostInfo().getHostname());
            this.simple.getLocal().setPort(this.port);
        }
    }
}

