/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.reactive.result.view;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.result.view.AbstractUrlBasedView;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MustacheView
extends AbstractUrlBasedView {
    private Mustache.Compiler compiler;
    private String charset;

    public void setCompiler(Mustache.Compiler compiler) {
        this.compiler = compiler;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public boolean checkResourceExists(Locale locale) throws Exception {
        return this.resolveResource() != null;
    }

    @Override
    protected Mono<Void> renderInternal(Map<String, Object> model, MediaType contentType, ServerWebExchange exchange2) {
        Resource resource2 = this.resolveResource();
        if (resource2 == null) {
            return Mono.error(new IllegalStateException("Could not find Mustache template with URL [" + this.getUrl() + "]"));
        }
        DataBuffer dataBuffer = exchange2.getResponse().bufferFactory().allocateBuffer(256);
        try (Reader reader = this.getReader(resource2);){
            Template template = this.compiler.compile(reader);
            Charset charset = this.getCharset(contentType).orElseGet(this::getDefaultCharset);
            try (OutputStreamWriter writer = new OutputStreamWriter(dataBuffer.asOutputStream(), charset);){
                template.execute(model, (Writer)writer);
                ((Writer)writer).flush();
            }
        }
        catch (Exception ex) {
            DataBufferUtils.release(dataBuffer);
            return Mono.error(ex);
        }
        return exchange2.getResponse().writeWith(Flux.just(dataBuffer));
    }

    private Resource resolveResource() {
        Resource resource2 = this.getApplicationContext().getResource(this.getUrl());
        if (resource2 == null || !resource2.exists()) {
            return null;
        }
        return resource2;
    }

    private Reader getReader(Resource resource2) throws IOException {
        if (this.charset != null) {
            return new InputStreamReader(resource2.getInputStream(), this.charset);
        }
        return new InputStreamReader(resource2.getInputStream());
    }

    private Optional<Charset> getCharset(MediaType mediaType) {
        return Optional.ofNullable(mediaType != null ? mediaType.getCharset() : null);
    }
}

