/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.annotation.SimpleReflectiveProcessor;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;

class OperationReflectiveProcessor
extends SimpleReflectiveProcessor {
    private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

    OperationReflectiveProcessor() {
    }

    @Override
    protected void registerMethodHint(ReflectionHints hints, Method method) {
        super.registerMethodHint(hints, method);
        Type returnType = this.extractReturnType(method);
        if (returnType != null) {
            this.registerReflectionHints(hints, returnType);
        }
    }

    private Type extractReturnType(Method method) {
        ResolvableType returnType = ResolvableType.forMethodReturnType(method);
        if (!WebEndpointResponse.class.isAssignableFrom(method.getReturnType())) {
            return returnType.getType();
        }
        return returnType.as(WebEndpointResponse.class).getGeneric(0).getType();
    }

    private void registerReflectionHints(ReflectionHints hints, Type type) {
        if (!type.equals(Resource.class)) {
            this.bindingRegistrar.registerReflectionHints(hints, type);
        }
    }
}

