/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.r2dbc;

import io.micrometer.observation.ObservationRegistry;
import io.r2dbc.proxy.ProxyConnectionFactory;
import io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.r2dbc.proxy.observation.ObservationProxyExecutionListener;
import io.r2dbc.proxy.observation.QueryObservationConvention;
import io.r2dbc.proxy.observation.QueryParametersTagProvider;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.r2dbc.R2dbcObservationProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.r2dbc.ConnectionFactoryDecorator;
import org.springframework.boot.r2dbc.OptionsCapableConnectionFactory;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={ObservationAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, ProxyConnectionFactory.class})
@EnableConfigurationProperties(value={R2dbcObservationProperties.class})
public class R2dbcObservationAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={ObservationRegistry.class})
    ConnectionFactoryDecorator connectionFactoryDecorator(R2dbcObservationProperties properties, ObservationRegistry observationRegistry, ObjectProvider<QueryObservationConvention> queryObservationConvention, ObjectProvider<QueryParametersTagProvider> queryParametersTagProvider) {
        return connectionFactory -> {
            HostAndPort hostAndPort = this.extractHostAndPort(connectionFactory);
            ObservationProxyExecutionListener listener = new ObservationProxyExecutionListener(observationRegistry, connectionFactory, hostAndPort.host(), hostAndPort.port());
            listener.setIncludeParameterValues(properties.isIncludeParameterValues());
            queryObservationConvention.ifAvailable(arg_0 -> ((ObservationProxyExecutionListener)listener).setQueryObservationConvention(arg_0));
            queryParametersTagProvider.ifAvailable(arg_0 -> ((ObservationProxyExecutionListener)listener).setQueryParametersTagProvider(arg_0));
            return ProxyConnectionFactory.builder((ConnectionFactory)connectionFactory).listener((ProxyExecutionListener)listener).build();
        };
    }

    private HostAndPort extractHostAndPort(ConnectionFactory connectionFactory) {
        String hostAsString;
        Object port;
        block5: {
            block4: {
                OptionsCapableConnectionFactory optionsCapableConnectionFactory = OptionsCapableConnectionFactory.unwrapFrom(connectionFactory);
                if (optionsCapableConnectionFactory == null) {
                    return HostAndPort.empty();
                }
                ConnectionFactoryOptions options = optionsCapableConnectionFactory.getOptions();
                Object host = options.getValue(ConnectionFactoryOptions.HOST);
                port = options.getValue(ConnectionFactoryOptions.PORT);
                if (!(host instanceof String)) break block4;
                hostAsString = (String)host;
                if (port instanceof Integer) break block5;
            }
            return HostAndPort.empty();
        }
        Integer portAsInt = (Integer)port;
        return new HostAndPort(hostAsString, portAsInt);
    }

    private record HostAndPort(String host, Integer port) {
        static HostAndPort empty() {
            return new HostAndPort(null, null);
        }
    }
}

