/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Map;
import java.util.function.Function;
import org.springframework.util.Assert;

public abstract class AbstractCompositeHealthContributorConfiguration<C, I extends C, B> {
    private final Function<B, I> indicatorFactory;

    protected AbstractCompositeHealthContributorConfiguration(Function<B, I> indicatorFactory) {
        this.indicatorFactory = indicatorFactory;
    }

    protected final C createContributor(Map<String, B> beans2) {
        Assert.notEmpty(beans2, "Beans must not be empty");
        if (beans2.size() == 1) {
            return (C)this.createIndicator(beans2.values().iterator().next());
        }
        return this.createComposite(beans2);
    }

    protected abstract C createComposite(Map<String, B> var1);

    protected I createIndicator(B bean2) {
        return this.indicatorFactory.apply(bean2);
    }
}

