/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.springframework.boot.actuate.endpoint.jackson.EndpointObjectMapper;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class JacksonEndpointAutoConfiguration {
    @Bean
    @ConditionalOnProperty(name={"management.endpoints.jackson.isolated-object-mapper"}, matchIfMissing=true)
    @ConditionalOnClass(value={ObjectMapper.class, Jackson2ObjectMapperBuilder.class})
    public EndpointObjectMapper endpointObjectMapper() {
        Object objectMapper = Jackson2ObjectMapperBuilder.json().featuresToDisable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS).serializationInclusion(JsonInclude.Include.NON_NULL).build();
        return () -> objectMapper;
    }
}

