/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import org.apache.commons.math.DimensionMismatchException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NotPositiveDefiniteMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.random.NormalizedRandomGenerator;
import org.apache.commons.math.random.RandomVectorGenerator;
import org.apache.commons.math.util.FastMath;

public class CorrelatedRandomVectorGenerator
implements RandomVectorGenerator {
    private final double[] mean;
    private final NormalizedRandomGenerator generator;
    private final double[] normalized;
    private RealMatrix root;
    private int rank;

    public CorrelatedRandomVectorGenerator(double[] mean, RealMatrix covariance, double small, NormalizedRandomGenerator generator) throws NotPositiveDefiniteMatrixException, DimensionMismatchException {
        int order = covariance.getRowDimension();
        if (mean.length != order) {
            throw new DimensionMismatchException(mean.length, order);
        }
        this.mean = (double[])mean.clone();
        this.decompose(covariance, small);
        this.generator = generator;
        this.normalized = new double[this.rank];
    }

    public CorrelatedRandomVectorGenerator(RealMatrix covariance, double small, NormalizedRandomGenerator generator) throws NotPositiveDefiniteMatrixException {
        int order = covariance.getRowDimension();
        this.mean = new double[order];
        for (int i2 = 0; i2 < order; ++i2) {
            this.mean[i2] = 0.0;
        }
        this.decompose(covariance, small);
        this.generator = generator;
        this.normalized = new double[this.rank];
    }

    public NormalizedRandomGenerator getGenerator() {
        return this.generator;
    }

    public RealMatrix getRootMatrix() {
        return this.root;
    }

    public int getRank() {
        return this.rank;
    }

    private void decompose(RealMatrix covariance, double small) throws NotPositiveDefiniteMatrixException {
        int i2;
        int order = covariance.getRowDimension();
        double[][] c = covariance.getData();
        double[][] b = new double[order][order];
        int[] swap = new int[order];
        int[] index = new int[order];
        for (i2 = 0; i2 < order; ++i2) {
            index[i2] = i2;
        }
        this.rank = 0;
        boolean loop = true;
        while (loop) {
            double sqrt;
            int ir;
            swap[this.rank] = this.rank;
            for (int i3 = this.rank + 1; i3 < order; ++i3) {
                int ii = index[i3];
                int isi = index[swap[i3]];
                if (!(c[ii][ii] > c[isi][isi])) continue;
                swap[this.rank] = i3;
            }
            if (swap[this.rank] != this.rank) {
                int tmp = index[this.rank];
                index[this.rank] = index[swap[this.rank]];
                index[swap[this.rank]] = tmp;
            }
            if (c[ir = index[this.rank]][ir] < small) {
                if (this.rank == 0) {
                    throw new NotPositiveDefiniteMatrixException();
                }
                for (int i4 = this.rank; i4 < order; ++i4) {
                    if (!(c[index[i4]][index[i4]] < -small)) continue;
                    throw new NotPositiveDefiniteMatrixException();
                }
                ++this.rank;
                loop = false;
                continue;
            }
            b[this.rank][this.rank] = sqrt = FastMath.sqrt(c[ir][ir]);
            double inverse = 1.0 / sqrt;
            for (int i5 = this.rank + 1; i5 < order; ++i5) {
                double e;
                int ii = index[i5];
                b[i5][this.rank] = e = inverse * c[ii][ir];
                double[] dArray = c[ii];
                int n = ii;
                dArray[n] = dArray[n] - e * e;
                for (int j = this.rank + 1; j < i5; ++j) {
                    double f;
                    int ij = index[j];
                    c[ii][ij] = f = c[ii][ij] - e * b[j][this.rank];
                    c[ij][ii] = f;
                }
            }
            loop = ++this.rank < order;
        }
        this.root = MatrixUtils.createRealMatrix(order, this.rank);
        for (i2 = 0; i2 < order; ++i2) {
            for (int j = 0; j < this.rank; ++j) {
                this.root.setEntry(index[i2], j, b[i2][j]);
            }
        }
    }

    public double[] nextVector() {
        for (int i2 = 0; i2 < this.rank; ++i2) {
            this.normalized[i2] = this.generator.nextNormalizedDouble();
        }
        double[] correlated = new double[this.mean.length];
        for (int i3 = 0; i3 < correlated.length; ++i3) {
            correlated[i3] = this.mean[i3];
            for (int j = 0; j < this.rank; ++j) {
                int n = i3;
                correlated[n] = correlated[n] + this.root.getEntry(i3, j) * this.normalized[j];
            }
        }
        return correlated;
    }
}

