/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.misc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stats {
    public static final String ANTLRWORKS_DIR = "antlrworks";

    public static double stddev(int[] X) {
        int m = X.length;
        if (m <= 1) {
            return 0.0;
        }
        double xbar = Stats.avg(X);
        double s2 = 0.0;
        for (int i2 = 0; i2 < m; ++i2) {
            s2 += ((double)X[i2] - xbar) * ((double)X[i2] - xbar);
        }
        return Math.sqrt(s2 /= (double)(m - 1));
    }

    public static double avg(int[] X) {
        double xbar = 0.0;
        int m = X.length;
        if (m == 0) {
            return 0.0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            xbar += (double)X[i2];
        }
        if (xbar >= 0.0) {
            return xbar / (double)m;
        }
        return 0.0;
    }

    public static int min(int[] X) {
        int min = Integer.MAX_VALUE;
        int m = X.length;
        if (m == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            if (X[i2] >= min) continue;
            min = X[i2];
        }
        return min;
    }

    public static int max(int[] X) {
        int max = Integer.MIN_VALUE;
        int m = X.length;
        if (m == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            if (X[i2] <= max) continue;
            max = X[i2];
        }
        return max;
    }

    public static double avg(List<Integer> X) {
        double xbar = 0.0;
        int m = X.size();
        if (m == 0) {
            return 0.0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            xbar += (double)X.get(i2).intValue();
        }
        if (xbar >= 0.0) {
            return xbar / (double)m;
        }
        return 0.0;
    }

    public static int min(List<Integer> X) {
        int min = Integer.MAX_VALUE;
        int m = X.size();
        if (m == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            if (X.get(i2) >= min) continue;
            min = X.get(i2);
        }
        return min;
    }

    public static int max(List<Integer> X) {
        int max = Integer.MIN_VALUE;
        int m = X.size();
        if (m == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            if (X.get(i2) <= max) continue;
            max = X.get(i2);
        }
        return max;
    }

    public static int sum(int[] X) {
        int s = 0;
        int m = X.length;
        if (m == 0) {
            return 0;
        }
        for (int i2 = 0; i2 < m; ++i2) {
            s += X[i2];
        }
        return s;
    }

    public static void writeReport(String filename, String data) throws IOException {
        String absoluteFilename = Stats.getAbsoluteFileName(filename);
        File f = new File(absoluteFilename);
        File parent = f.getParentFile();
        parent.mkdirs();
        FileOutputStream fos = new FileOutputStream(f, true);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintStream ps = new PrintStream(bos);
        ps.println(data);
        ps.close();
        bos.close();
        fos.close();
    }

    public static String getAbsoluteFileName(String filename) {
        return new StringBuffer().append(System.getProperty("user.home")).append(File.separator).append(ANTLRWORKS_DIR).append(File.separator).append(filename).toString();
    }
}

