/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.infix;

import com.netflix.infix.TimeMillisValuePredicate;
import com.netflix.infix.TimeUtil;
import com.netflix.infix.ValuePredicate;
import javax.annotation.Nullable;
import org.joda.time.format.DateTimeFormatter;

public class TimeStringValuePredicate
implements ValuePredicate<String> {
    private String valueFormat;
    private String inputFormat;
    private String value;
    private String fnName;
    private DateTimeFormatter inputTimeFormatter;
    private TimeMillisValuePredicate timePredicate;

    public TimeStringValuePredicate(String valueFormat, String inputFormat, String value, String fnName) {
        this.valueFormat = valueFormat;
        this.inputFormat = inputFormat;
        this.value = value;
        this.fnName = fnName;
        this.inputTimeFormatter = TimeUtil.toDateTimeFormatter("input format", inputFormat);
        this.timePredicate = new TimeMillisValuePredicate(this.valueFormat, value, fnName);
    }

    @Override
    public boolean apply(@Nullable String input) {
        long timeValue = this.inputTimeFormatter.parseMillis(input);
        return this.timePredicate.apply(timeValue);
    }

    public String getValue() {
        return this.value;
    }

    public String getValueFormat() {
        return this.valueFormat;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    String getFnName() {
        return this.fnName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeStringValuePredicate [valueFormat=");
        builder.append(this.valueFormat);
        builder.append(", inputFormat=");
        builder.append(this.inputFormat);
        builder.append(", value=");
        builder.append(this.value);
        builder.append(", fnName=");
        builder.append(this.fnName);
        builder.append(", inputTimeFormatter=");
        builder.append(this.inputTimeFormatter);
        builder.append(", timePredicate=");
        builder.append(this.timePredicate);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fnName == null ? 0 : this.fnName.hashCode());
        result = 31 * result + (this.inputFormat == null ? 0 : this.inputFormat.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.valueFormat == null ? 0 : this.valueFormat.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeStringValuePredicate other = (TimeStringValuePredicate)obj;
        if (this.fnName == null ? other.fnName != null : !this.fnName.equals(other.fnName)) {
            return false;
        }
        if (this.inputFormat == null ? other.inputFormat != null : !this.inputFormat.equals(other.inputFormat)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.valueFormat == null ? other.valueFormat != null : !this.valueFormat.equals(other.valueFormat));
    }
}

