/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.dataformat.xml.ser.XmlBeanSerializer;
import com.netflix.discovery.converters.KeyFormatter;
import com.netflix.discovery.shared.Applications;
import java.io.IOException;

public class ApplicationsXmlBeanSerializer
extends XmlBeanSerializer {
    private final String versionKey;
    private final String appsHashCodeKey;

    public ApplicationsXmlBeanSerializer(BeanSerializerBase src, KeyFormatter keyFormatter) {
        super(src);
        this.versionKey = keyFormatter.formatKey("versions_delta");
        this.appsHashCodeKey = keyFormatter.formatKey("apps_hashcode");
    }

    protected void serializeFields(Object bean2, JsonGenerator jgen0, SerializerProvider provider) throws IOException {
        super.serializeFields(bean2, jgen0, provider);
        Applications applications = (Applications)bean2;
        if (applications.getVersion() != null) {
            jgen0.writeStringField(this.versionKey, Long.toString(applications.getVersion()));
        }
        if (applications.getAppsHashCode() != null) {
            jgen0.writeStringField(this.appsHashCodeKey, applications.getAppsHashCode());
        }
    }
}

