/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson.builder;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.discovery.converters.EnumLookup;
import com.netflix.discovery.converters.EurekaJacksonCodec;
import com.netflix.discovery.util.DeserializerStringCache;
import com.netflix.discovery.util.StringCache;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class StringInterningAmazonInfoBuilder
extends JsonDeserializer<AmazonInfo> {
    private static final Map<String, DeserializerStringCache.CacheScope> VALUE_INTERN_KEYS;
    private static final char[] BUF_METADATA;
    private HashMap<String, String> metadata;

    public StringInterningAmazonInfoBuilder withName(String name) {
        return this;
    }

    public StringInterningAmazonInfoBuilder withMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
        if (metadata.isEmpty()) {
            return this;
        }
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            String key = entry.getKey().intern();
            if (!VALUE_INTERN_KEYS.containsKey(key)) continue;
            entry.setValue(StringCache.intern(entry.getValue()));
        }
        return this;
    }

    public AmazonInfo build() {
        return new AmazonInfo(DataCenterInfo.Name.Amazon.name(), this.metadata);
    }

    private boolean isEndOfObjectOrInput(JsonToken token) {
        return token == null || token == JsonToken.END_OBJECT;
    }

    private boolean skipToMetadata(JsonParser jp) throws IOException {
        JsonToken token = jp.getCurrentToken();
        while (!this.isEndOfObjectOrInput(token)) {
            if (token == JsonToken.FIELD_NAME && EnumLookup.equals(BUF_METADATA, jp.getTextCharacters(), jp.getTextOffset(), jp.getTextLength())) {
                return true;
            }
            token = jp.nextToken();
        }
        return false;
    }

    private void skipToEnd(JsonParser jp) throws IOException {
        JsonToken token = jp.getCurrentToken();
        while (!this.isEndOfObjectOrInput(token)) {
            token = jp.nextToken();
        }
    }

    @Override
    public AmazonInfo deserialize(JsonParser jp, DeserializationContext context) throws IOException {
        Map<String, String> metadata = EurekaJacksonCodec.METADATA_MAP_SUPPLIER.get();
        DeserializerStringCache intern = DeserializerStringCache.from(context);
        if (this.skipToMetadata(jp)) {
            JsonToken jsonToken = jp.nextToken();
            while ((jsonToken = jp.nextToken()) != JsonToken.END_OBJECT) {
                String metadataKey = intern.apply(jp, DeserializerStringCache.CacheScope.GLOBAL_SCOPE);
                jp.nextToken();
                DeserializerStringCache.CacheScope scope = VALUE_INTERN_KEYS.get(metadataKey);
                String metadataValue = scope != null ? intern.apply(jp, scope) : intern.apply(jp, DeserializerStringCache.CacheScope.APPLICATION_SCOPE);
                metadata.put(metadataKey, metadataValue);
            }
            this.skipToEnd(jp);
        }
        if (jp.getCurrentToken() == JsonToken.END_OBJECT) {
            jp.nextToken();
        }
        return new AmazonInfo(DataCenterInfo.Name.Amazon.name(), metadata);
    }

    static {
        BUF_METADATA = "metadata".toCharArray();
        HashMap<String, DeserializerStringCache.CacheScope> keys = new HashMap<String, DeserializerStringCache.CacheScope>();
        keys.put(AmazonInfo.MetaDataKey.accountId.getName(), DeserializerStringCache.CacheScope.GLOBAL_SCOPE);
        keys.put(AmazonInfo.MetaDataKey.amiId.getName(), DeserializerStringCache.CacheScope.GLOBAL_SCOPE);
        keys.put(AmazonInfo.MetaDataKey.availabilityZone.getName(), DeserializerStringCache.CacheScope.GLOBAL_SCOPE);
        keys.put(AmazonInfo.MetaDataKey.instanceType.getName(), DeserializerStringCache.CacheScope.GLOBAL_SCOPE);
        keys.put(AmazonInfo.MetaDataKey.vpcId.getName(), DeserializerStringCache.CacheScope.GLOBAL_SCOPE);
        keys.put(AmazonInfo.MetaDataKey.publicIpv4.getName(), DeserializerStringCache.CacheScope.APPLICATION_SCOPE);
        keys.put(AmazonInfo.MetaDataKey.localHostname.getName(), DeserializerStringCache.CacheScope.APPLICATION_SCOPE);
        VALUE_INTERN_KEYS = keys;
    }
}

