/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.FluxHide;
import reactor.core.publisher.InternalProducerAttr;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ParallelFlux;
import reactor.util.annotation.Nullable;

final class ParallelLiftFuseable<I, O>
extends ParallelFlux<O>
implements Scannable,
Fuseable {
    final Operators.LiftFunction<I, O> liftFunction;
    final ParallelFlux<I> source;

    ParallelLiftFuseable(ParallelFlux<I> p, Operators.LiftFunction<I, O> liftFunction) {
        this.source = ParallelFlux.from(Objects.requireNonNull(p, "source"));
        this.liftFunction = liftFunction;
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.from(this.source).scanUnsafe(key);
        }
        if (key == Scannable.Attr.LIFTER) {
            return this.liftFunction.name;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return null;
    }

    @Override
    public String stepName() {
        if (this.source instanceof Scannable) {
            return Scannable.from(this.source).stepName();
        }
        return Scannable.super.stepName();
    }

    @Override
    public void subscribe(CoreSubscriber<? super O>[] s) {
        CoreSubscriber[] subscribers = new CoreSubscriber[this.parallelism()];
        for (int i2 = 0; i2 < subscribers.length; ++i2) {
            CoreSubscriber<? super O> actual = s[i2];
            CoreSubscriber converted = Objects.requireNonNull(this.liftFunction.lifter.apply(this.source, Operators.restoreContextOnSubscriberIfAutoCPEnabled(this.source, actual)), "Lifted subscriber MUST NOT be null");
            Objects.requireNonNull(converted, "Lifted subscriber MUST NOT be null");
            if (actual instanceof Fuseable.QueueSubscription && !(converted instanceof Fuseable.QueueSubscription)) {
                converted = new FluxHide.SuppressFuseableSubscriber(converted);
            }
            subscribers[i2] = converted;
        }
        this.source.subscribe(subscribers);
    }
}

