/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.stats;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.CompletionContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancerLifecycle;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.TimedRequestContext;
import org.springframework.cloud.loadbalancer.stats.LoadBalancerTags;

public class MicrometerStatsLoadBalancerLifecycle
implements LoadBalancerLifecycle<Object, Object, ServiceInstance> {
    private final MeterRegistry meterRegistry;
    private final ConcurrentHashMap<ServiceInstance, AtomicLong> activeRequestsPerInstance = new ConcurrentHashMap();

    public MicrometerStatsLoadBalancerLifecycle(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public boolean supports(Class requestContextClass, Class responseClass, Class serverTypeClass) {
        return ServiceInstance.class.isAssignableFrom(serverTypeClass);
    }

    @Override
    public void onStart(Request<Object> request) {
    }

    @Override
    public void onStartRequest(Request<Object> request, Response<ServiceInstance> lbResponse) {
        if (request.getContext() instanceof TimedRequestContext) {
            ((TimedRequestContext)request.getContext()).setRequestStartTime(System.nanoTime());
        }
        if (!lbResponse.hasServer()) {
            return;
        }
        ServiceInstance serviceInstance = lbResponse.getServer();
        AtomicLong activeRequestsCounter = this.activeRequestsPerInstance.computeIfAbsent(serviceInstance, instance -> {
            AtomicLong createdCounter = new AtomicLong();
            Gauge.builder((String)"loadbalancer.requests.active", () -> createdCounter).tags(LoadBalancerTags.buildServiceInstanceTags(serviceInstance)).register(this.meterRegistry);
            return createdCounter;
        });
        activeRequestsCounter.incrementAndGet();
    }

    @Override
    public void onComplete(CompletionContext<Object, ServiceInstance, Object> completionContext) {
        Object loadBalancerRequestContext;
        long requestFinishedTimestamp = System.nanoTime();
        if (CompletionContext.Status.DISCARD.equals((Object)completionContext.status())) {
            Counter.builder((String)"loadbalancer.requests.discard").tags(LoadBalancerTags.buildDiscardedRequestTags(completionContext)).register(this.meterRegistry).increment();
            return;
        }
        ServiceInstance serviceInstance = completionContext.getLoadBalancerResponse().getServer();
        AtomicLong activeRequestsCounter = this.activeRequestsPerInstance.get(serviceInstance);
        if (activeRequestsCounter != null) {
            activeRequestsCounter.decrementAndGet();
        }
        if (this.requestHasBeenTimed(loadBalancerRequestContext = completionContext.getLoadBalancerRequest().getContext())) {
            if (CompletionContext.Status.FAILED.equals((Object)completionContext.status())) {
                Timer.builder((String)"loadbalancer.requests.failed").tags(LoadBalancerTags.buildFailedRequestTags(completionContext)).register(this.meterRegistry).record(requestFinishedTimestamp - ((TimedRequestContext)loadBalancerRequestContext).getRequestStartTime(), TimeUnit.NANOSECONDS);
                return;
            }
            Timer.builder((String)"loadbalancer.requests.success").tags(LoadBalancerTags.buildSuccessRequestTags(completionContext)).register(this.meterRegistry).record(requestFinishedTimestamp - ((TimedRequestContext)loadBalancerRequestContext).getRequestStartTime(), TimeUnit.NANOSECONDS);
        }
    }

    private boolean requestHasBeenTimed(Object loadBalancerRequestContext) {
        return loadBalancerRequestContext instanceof TimedRequestContext && ((TimedRequestContext)loadBalancerRequestContext).getRequestStartTime() != 0L;
    }
}

