/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.loadbalancer.core.SelectedInstanceCallback;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.util.Assert;

public abstract class DelegatingServiceInstanceListSupplier
implements ServiceInstanceListSupplier,
SelectedInstanceCallback,
InitializingBean,
DisposableBean {
    protected final ServiceInstanceListSupplier delegate;

    public DelegatingServiceInstanceListSupplier(ServiceInstanceListSupplier delegate) {
        Assert.notNull((Object)delegate, "delegate may not be null");
        this.delegate = delegate;
    }

    public ServiceInstanceListSupplier getDelegate() {
        return this.delegate;
    }

    @Override
    public String getServiceId() {
        return this.delegate.getServiceId();
    }

    @Override
    public void selectedServiceInstance(ServiceInstance serviceInstance) {
        ServiceInstanceListSupplier serviceInstanceListSupplier = this.delegate;
        if (serviceInstanceListSupplier instanceof SelectedInstanceCallback) {
            SelectedInstanceCallback selectedInstanceCallbackDelegate = (SelectedInstanceCallback)((Object)serviceInstanceListSupplier);
            selectedInstanceCallbackDelegate.selectedServiceInstance(serviceInstance);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.delegate instanceof InitializingBean) {
            ((InitializingBean)((Object)this.delegate)).afterPropertiesSet();
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.delegate instanceof DisposableBean) {
            ((DisposableBean)((Object)this.delegate)).destroy();
        }
    }
}

