/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.environment;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.Show;
import org.springframework.boot.actuate.endpoint.annotation.DeleteOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.EndpointWebExtension;
import org.springframework.boot.actuate.env.EnvironmentEndpoint;
import org.springframework.boot.actuate.env.EnvironmentEndpointWebExtension;
import org.springframework.cloud.context.environment.EnvironmentManager;
import org.springframework.cloud.context.environment.WritableEnvironmentEndpoint;

@EndpointWebExtension(endpoint=WritableEnvironmentEndpoint.class)
public class WritableEnvironmentEndpointWebExtension
extends EnvironmentEndpointWebExtension {
    private EnvironmentManager environment;

    public WritableEnvironmentEndpointWebExtension(WritableEnvironmentEndpoint endpoint, EnvironmentManager environment2, Show showValues, Set<String> roles) {
        super((EnvironmentEndpoint)endpoint, showValues, roles);
        this.environment = environment2;
    }

    @WriteOperation
    public Object write(String name, String value) {
        this.environment.setProperty(name, value);
        return Collections.singletonMap(name, value);
    }

    @DeleteOperation
    public Map<String, Object> reset() {
        return this.environment.reset();
    }

    public void setEnvironmentManager(EnvironmentManager environment2) {
        this.environment = environment2;
    }
}

