/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerClientRequestTransformer;
import org.springframework.http.HttpMethod;
import org.springframework.web.reactive.function.client.ClientRequest;

public final class ExchangeFilterFunctionUtils {
    private ExchangeFilterFunctionUtils() {
        throw new IllegalStateException("Can't instantiate a utility class.");
    }

    static String getHint(String serviceId, Map<String, String> hints) {
        String defaultHint = hints.getOrDefault("default", "default");
        String hintPropertyValue = hints.get(serviceId);
        return hintPropertyValue != null ? hintPropertyValue : defaultHint;
    }

    static ClientRequest buildClientRequest(ClientRequest request, ServiceInstance serviceInstance, String instanceIdCookieName, boolean addServiceInstanceCookie, List<LoadBalancerClientRequestTransformer> transformers) {
        URI originalUrl = request.url();
        ClientRequest clientRequest = ClientRequest.create((HttpMethod)request.method(), (URI)LoadBalancerUriTools.reconstructURI(serviceInstance, originalUrl)).headers(headers -> headers.addAll(request.headers())).cookies(cookies -> {
            cookies.addAll(request.cookies());
            if (instanceIdCookieName != null && instanceIdCookieName.length() != 0 && addServiceInstanceCookie) {
                cookies.add(instanceIdCookieName, serviceInstance.getInstanceId());
            }
        }).attributes(attributes -> attributes.putAll(request.attributes())).body(request.body()).build();
        if (transformers != null) {
            for (LoadBalancerClientRequestTransformer transformer : transformers) {
                clientRequest = transformer.transformRequest(clientRequest, serviceInstance);
            }
        }
        return clientRequest;
    }

    static String serviceInstanceUnavailableMessage(String serviceId) {
        return "LoadBalancer does not contain an instance for the service " + serviceId;
    }
}

