/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.elasticsearch;

import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.client.sniff.SnifferBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchConnectionDetails;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchProperties;
import org.springframework.boot.autoconfigure.elasticsearch.RestClientBuilderCustomizer;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

class ElasticsearchRestClientConfigurations {
    ElasticsearchRestClientConfigurations() {
    }

    static class PropertiesElasticsearchConnectionDetails
    implements ElasticsearchConnectionDetails {
        private final ElasticsearchProperties properties;

        PropertiesElasticsearchConnectionDetails(ElasticsearchProperties properties) {
            this.properties = properties;
        }

        @Override
        public List<ElasticsearchConnectionDetails.Node> getNodes() {
            return this.properties.getUris().stream().map(this::createNode).toList();
        }

        @Override
        public String getUsername() {
            return this.properties.getUsername();
        }

        @Override
        public String getPassword() {
            return this.properties.getPassword();
        }

        @Override
        public String getPathPrefix() {
            return this.properties.getPathPrefix();
        }

        private ElasticsearchConnectionDetails.Node createNode(String uri) {
            if (!((String)uri).startsWith("http://") && !((String)uri).startsWith("https://")) {
                uri = "http://" + (String)uri;
            }
            return this.createNode(URI.create((String)uri));
        }

        private ElasticsearchConnectionDetails.Node createNode(URI uri) {
            String userInfo = uri.getUserInfo();
            ElasticsearchConnectionDetails.Node.Protocol protocol = ElasticsearchConnectionDetails.Node.Protocol.forScheme(uri.getScheme());
            if (!StringUtils.hasLength(userInfo)) {
                return new ElasticsearchConnectionDetails.Node(uri.getHost(), uri.getPort(), protocol, null, null);
            }
            int separatorIndex = userInfo.indexOf(58);
            if (separatorIndex == -1) {
                return new ElasticsearchConnectionDetails.Node(uri.getHost(), uri.getPort(), protocol, userInfo, null);
            }
            String[] components = userInfo.split(":");
            return new ElasticsearchConnectionDetails.Node(uri.getHost(), uri.getPort(), protocol, components[0], components.length > 1 ? components[1] : "");
        }
    }

    private static class ConnectionDetailsCredentialsProvider
    extends BasicCredentialsProvider {
        ConnectionDetailsCredentialsProvider(ElasticsearchConnectionDetails connectionDetails) {
            String username = connectionDetails.getUsername();
            if (StringUtils.hasText(username)) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, connectionDetails.getPassword());
                this.setCredentials(AuthScope.ANY, credentials);
            }
            Stream<URI> uris = this.getUris(connectionDetails);
            uris.filter(this::hasUserInfo).forEach(this::addUserInfoCredentials);
        }

        private Stream<URI> getUris(ElasticsearchConnectionDetails connectionDetails) {
            return connectionDetails.getNodes().stream().map(ElasticsearchConnectionDetails.Node::toUri);
        }

        private boolean hasUserInfo(URI uri) {
            return uri != null && StringUtils.hasLength(uri.getUserInfo());
        }

        private void addUserInfoCredentials(URI uri) {
            AuthScope authScope = new AuthScope(uri.getHost(), uri.getPort());
            Credentials credentials = this.createUserInfoCredentials(uri.getUserInfo());
            this.setCredentials(authScope, credentials);
        }

        private Credentials createUserInfoCredentials(String userInfo) {
            int delimiter = userInfo.indexOf(":");
            if (delimiter == -1) {
                return new UsernamePasswordCredentials(userInfo, null);
            }
            String username = userInfo.substring(0, delimiter);
            String password = userInfo.substring(delimiter + 1);
            return new UsernamePasswordCredentials(username, password);
        }
    }

    static class DefaultRestClientBuilderCustomizer
    implements RestClientBuilderCustomizer {
        private static final PropertyMapper map = PropertyMapper.get();
        private final ElasticsearchProperties properties;
        private final ElasticsearchConnectionDetails connectionDetails;

        DefaultRestClientBuilderCustomizer(ElasticsearchProperties properties, ElasticsearchConnectionDetails connectionDetails) {
            this.properties = properties;
            this.connectionDetails = connectionDetails;
        }

        @Override
        public void customize(RestClientBuilder builder) {
        }

        @Override
        public void customize(HttpAsyncClientBuilder builder) {
            builder.setDefaultCredentialsProvider((CredentialsProvider)new ConnectionDetailsCredentialsProvider(this.connectionDetails));
            map.from(this.properties::isSocketKeepAlive).to(keepAlive -> builder.setDefaultIOReactorConfig(IOReactorConfig.custom().setSoKeepAlive(keepAlive.booleanValue()).build()));
        }

        @Override
        public void customize(RequestConfig.Builder builder) {
            map.from(this.properties::getConnectionTimeout).whenNonNull().asInt(Duration::toMillis).to(builder::setConnectTimeout);
            map.from(this.properties::getSocketTimeout).whenNonNull().asInt(Duration::toMillis).to(builder::setSocketTimeout);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Sniffer.class})
    @ConditionalOnSingleCandidate(value=RestClient.class)
    static class RestClientSnifferConfiguration {
        RestClientSnifferConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        Sniffer elasticsearchSniffer(RestClient client, ElasticsearchProperties properties) {
            SnifferBuilder builder = Sniffer.builder((RestClient)client);
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            Duration interval = properties.getRestclient().getSniffer().getInterval();
            map.from(interval).asInt(Duration::toMillis).to(arg_0 -> ((SnifferBuilder)builder).setSniffIntervalMillis(arg_0));
            Duration delayAfterFailure = properties.getRestclient().getSniffer().getDelayAfterFailure();
            map.from(delayAfterFailure).asInt(Duration::toMillis).to(arg_0 -> ((SnifferBuilder)builder).setSniffAfterFailureDelayMillis(arg_0));
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={RestClient.class})
    static class RestClientConfiguration {
        RestClientConfiguration() {
        }

        @Bean
        RestClient elasticsearchRestClient(RestClientBuilder restClientBuilder) {
            return restClientBuilder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={RestClientBuilder.class})
    static class RestClientBuilderConfiguration {
        private final ElasticsearchProperties properties;

        RestClientBuilderConfiguration(ElasticsearchProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean(value={ElasticsearchConnectionDetails.class})
        PropertiesElasticsearchConnectionDetails elasticsearchConnectionDetails() {
            return new PropertiesElasticsearchConnectionDetails(this.properties);
        }

        @Bean
        RestClientBuilderCustomizer defaultRestClientBuilderCustomizer(ElasticsearchConnectionDetails connectionDetails) {
            return new DefaultRestClientBuilderCustomizer(this.properties, connectionDetails);
        }

        @Bean
        RestClientBuilder elasticsearchRestClientBuilder(ElasticsearchConnectionDetails connectionDetails, ObjectProvider<RestClientBuilderCustomizer> builderCustomizers, ObjectProvider<SslBundles> sslBundles) {
            RestClientBuilder builder = RestClient.builder((HttpHost[])((HttpHost[])connectionDetails.getNodes().stream().map(node -> new HttpHost(node.hostname(), node.port(), node.protocol().getScheme())).toArray(HttpHost[]::new)));
            builder.setHttpClientConfigCallback(httpClientBuilder -> {
                builderCustomizers.orderedStream().forEach(customizer2 -> customizer2.customize(httpClientBuilder));
                String sslBundleName = this.properties.getRestclient().getSsl().getBundle();
                if (StringUtils.hasText(sslBundleName)) {
                    this.configureSsl(httpClientBuilder, ((SslBundles)sslBundles.getObject()).getBundle(sslBundleName));
                }
                return httpClientBuilder;
            });
            builder.setRequestConfigCallback(requestConfigBuilder -> {
                builderCustomizers.orderedStream().forEach(customizer2 -> customizer2.customize(requestConfigBuilder));
                return requestConfigBuilder;
            });
            String pathPrefix = connectionDetails.getPathPrefix();
            if (pathPrefix != null) {
                builder.setPathPrefix(pathPrefix);
            }
            builderCustomizers.orderedStream().forEach(customizer2 -> customizer2.customize(builder));
            return builder;
        }

        private void configureSsl(HttpAsyncClientBuilder httpClientBuilder, SslBundle sslBundle) {
            SSLContext sslcontext = sslBundle.createSslContext();
            SslOptions sslOptions = sslBundle.getOptions();
            httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)new SSLIOSessionStrategy(sslcontext, sslOptions.getEnabledProtocols(), sslOptions.getCiphers(), (HostnameVerifier)null));
        }
    }
}

