/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.summary;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.util.FastMath;

public class SumOfLogs
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -370076995648386763L;
    private int n;
    private double value;

    public SumOfLogs() {
        this.value = 0.0;
        this.n = 0;
    }

    public SumOfLogs(SumOfLogs original) {
        SumOfLogs.copy(original, this);
    }

    public void increment(double d) {
        this.value += FastMath.log(d);
        ++this.n;
    }

    public double getResult() {
        if (this.n > 0) {
            return this.value;
        }
        return Double.NaN;
    }

    public long getN() {
        return this.n;
    }

    public void clear() {
        this.value = 0.0;
        this.n = 0;
    }

    public double evaluate(double[] values, int begin, int length) {
        double sumLog = Double.NaN;
        if (this.test(values, begin, length)) {
            sumLog = 0.0;
            for (int i2 = begin; i2 < begin + length; ++i2) {
                sumLog += FastMath.log(values[i2]);
            }
        }
        return sumLog;
    }

    public SumOfLogs copy() {
        SumOfLogs result = new SumOfLogs();
        SumOfLogs.copy(this, result);
        return result;
    }

    public static void copy(SumOfLogs source, SumOfLogs dest) {
        dest.setData(source.getDataRef());
        dest.n = source.n;
        dest.value = source.value;
    }
}

