/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.BlockRealMatrix;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.QRDecompositionImpl;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.VectorialPointValuePair;
import org.apache.commons.math.optimization.general.AbstractLeastSquaresOptimizer;

public class GaussNewtonOptimizer
extends AbstractLeastSquaresOptimizer {
    private final boolean useLU;

    public GaussNewtonOptimizer(boolean useLU) {
        this.useLU = useLU;
    }

    public VectorialPointValuePair doOptimize() throws FunctionEvaluationException, OptimizationException, IllegalArgumentException {
        VectorialPointValuePair current = null;
        boolean converged = false;
        while (!converged) {
            this.incrementIterationsCounter();
            VectorialPointValuePair previous = current;
            this.updateResidualsAndCost();
            this.updateJacobian();
            current = new VectorialPointValuePair(this.point, this.objective);
            double[] b = new double[this.cols];
            double[][] a = new double[this.cols][this.cols];
            for (int i2 = 0; i2 < this.rows; ++i2) {
                double[] grad = this.jacobian[i2];
                double weight = this.residualsWeights[i2];
                double residual = this.objective[i2] - this.targetValues[i2];
                double wr = weight * residual;
                for (int j = 0; j < this.cols; ++j) {
                    int n = j;
                    b[n] = b[n] + wr * grad[j];
                }
                for (int k = 0; k < this.cols; ++k) {
                    double[] ak = a[k];
                    double wgk = weight * grad[k];
                    for (int l = 0; l < this.cols; ++l) {
                        int n = l;
                        ak[n] = ak[n] + wgk * grad[l];
                    }
                }
            }
            try {
                BlockRealMatrix mA = new BlockRealMatrix(a);
                DecompositionSolver solver = this.useLU ? new LUDecompositionImpl(mA).getSolver() : new QRDecompositionImpl(mA).getSolver();
                double[] dX = solver.solve(b);
                for (int i3 = 0; i3 < this.cols; ++i3) {
                    int n = i3;
                    this.point[n] = this.point[n] + dX[i3];
                }
            }
            catch (InvalidMatrixException e) {
                throw new OptimizationException(LocalizedFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, new Object[0]);
            }
            if (previous == null) continue;
            converged = this.checker.converged(this.getIterations(), previous, current);
        }
        return current;
    }
}

