/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.infix;

import com.google.common.base.Objects;
import com.netflix.infix.ValuePredicate;
import javax.annotation.Nullable;
import org.apache.commons.jxpath.JXPathContext;

public class XPathValuePredicate
implements ValuePredicate<String> {
    private String valueXpath;
    private String inputXpath;

    public XPathValuePredicate(String valueXpath, String inputXpath) {
        this.valueXpath = valueXpath;
        this.inputXpath = inputXpath;
    }

    @Override
    public boolean apply(@Nullable String input) {
        JXPathContext context = JXPathContext.newContext(input);
        context.setLenient(true);
        return Objects.equal(context.getValue(this.valueXpath), context.getValue(this.inputXpath));
    }

    public String getInputXpath() {
        return this.inputXpath;
    }

    public String getValueXpath() {
        return this.valueXpath;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inputXpath == null ? 0 : this.inputXpath.hashCode());
        result = 31 * result + (this.valueXpath == null ? 0 : this.valueXpath.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XPathValuePredicate other = (XPathValuePredicate)obj;
        if (this.inputXpath == null ? other.inputXpath != null : !this.inputXpath.equals(other.inputXpath)) {
            return false;
        }
        return !(this.valueXpath == null ? other.valueXpath != null : !this.valueXpath.equals(other.valueXpath));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PathValuePredicate [valueXpath=");
        builder.append(this.valueXpath);
        builder.append(", inputXpath=");
        builder.append(this.inputXpath);
        builder.append("]");
        return builder.toString();
    }
}

