/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import jakarta.inject.Singleton;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

@Singleton
public class GzipEncodingEnforcingFilter
implements Filter {
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if ("GET".equals(httpRequest.getMethod())) {
            String acceptEncoding = httpRequest.getHeader("Accept-Encoding");
            if (acceptEncoding == null) {
                chain.doFilter(GzipEncodingEnforcingFilter.addGzipAcceptEncoding(httpRequest), response);
                return;
            }
            if (!acceptEncoding.contains("gzip")) {
                ((HttpServletResponse)response).setStatus(406);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }

    private static HttpServletRequest addGzipAcceptEncoding(HttpServletRequest request) {
        return new HttpServletRequestWrapper(request){

            @Override
            public Enumeration<String> getHeaders(String name) {
                if ("Accept-Encoding".equals(name)) {
                    return new EnumWrapper<String>("gzip");
                }
                return super.getHeaders(name);
            }

            @Override
            public Enumeration<String> getHeaderNames() {
                return new EnumWrapper<String>(super.getHeaderNames(), "Accept-Encoding");
            }

            @Override
            public String getHeader(String name) {
                if ("Accept-Encoding".equals(name)) {
                    return "gzip";
                }
                return super.getHeader(name);
            }
        };
    }

    private static class EnumWrapper<E>
    implements Enumeration<E> {
        private final Enumeration<E> delegate;
        private final AtomicReference<E> extraElementRef;

        private EnumWrapper(E extraElement) {
            this(null, extraElement);
        }

        private EnumWrapper(Enumeration<E> delegate, E extraElement) {
            this.delegate = delegate;
            this.extraElementRef = new AtomicReference<E>(extraElement);
        }

        @Override
        public boolean hasMoreElements() {
            return this.extraElementRef.get() != null || this.delegate != null && this.delegate.hasMoreElements();
        }

        @Override
        public E nextElement() {
            E extra = this.extraElementRef.getAndSet(null);
            if (extra != null) {
                return extra;
            }
            if (this.delegate == null) {
                throw new NoSuchElementException();
            }
            return this.delegate.nextElement();
        }
    }
}

