/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.converters.jackson.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import java.io.IOException;
import java.util.ArrayList;

public class ApplicationXmlDeserializer
extends StdDeserializer<Application> {
    public ApplicationXmlDeserializer() {
        super(Application.class);
    }

    @Override
    public Application deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String name = null;
        ArrayList<InstanceInfo> instances = new ArrayList<InstanceInfo>();
        while (jp.nextToken() == JsonToken.FIELD_NAME) {
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("name".equals(fieldName)) {
                name = jp.getValueAsString();
                continue;
            }
            if ("instance".equals(fieldName)) {
                instances.add(jp.readValueAs(InstanceInfo.class));
                continue;
            }
            throw new JsonMappingException("Unexpected field " + fieldName, jp.getCurrentLocation());
        }
        return new Application(name, instances);
    }
}

