/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.StatusChangeEvent;
import com.netflix.eventbus.spi.EventBus;
import com.netflix.eventbus.spi.InvalidSubscriberException;
import com.netflix.eventbus.spi.Subscribe;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EurekaUpStatusResolver {
    private static Logger LOG = LoggerFactory.getLogger(EurekaUpStatusResolver.class);
    private volatile InstanceInfo.InstanceStatus currentStatus = InstanceInfo.InstanceStatus.UNKNOWN;
    private final EventBus eventBus;
    private final EurekaClient client;
    private final AtomicLong counter = new AtomicLong();

    @Inject
    public EurekaUpStatusResolver(EurekaClient client, EventBus eventBus) {
        this.eventBus = eventBus;
        this.client = client;
    }

    @Subscribe
    public void onStatusChange(StatusChangeEvent event) {
        LOG.info("Eureka status changed from {} to {}", (Object)event.getPreviousStatus(), (Object)event.getStatus());
        this.currentStatus = event.getStatus();
        this.counter.incrementAndGet();
    }

    @PostConstruct
    public void init() {
        try {
            this.currentStatus = this.client.getInstanceRemoteStatus();
            LOG.info("Initial status set to {}", (Object)this.currentStatus);
            this.eventBus.registerSubscriber(this);
        }
        catch (InvalidSubscriberException e) {
            LOG.error("Error registring for discovery status change events.", e);
        }
    }

    @PreDestroy
    public void shutdown() {
        this.eventBus.unregisterSubscriber(this);
    }

    public InstanceInfo.InstanceStatus getStatus() {
        return this.currentStatus;
    }

    public long getChangeCount() {
        return this.counter.get();
    }
}

