/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.netflix.appinfo.HealthCheckCallback;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.discovery.EurekaEvent;
import com.netflix.discovery.EurekaEventListener;
import com.netflix.discovery.PreRegistrationHandler;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.eventbus.spi.EventBus;
import jakarta.inject.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public abstract class AbstractDiscoveryClientOptionalArgs<T> {
    Provider<HealthCheckCallback> healthCheckCallbackProvider;
    Provider<HealthCheckHandler> healthCheckHandlerProvider;
    PreRegistrationHandler preRegistrationHandler;
    Collection<T> additionalFilters;
    TransportClientFactory transportClientFactory;
    private Set<EurekaEventListener> eventListeners;
    private Optional<SSLContext> sslContext = Optional.empty();
    private Optional<HostnameVerifier> hostnameVerifier = Optional.empty();

    public void setEventListeners(Set<EurekaEventListener> listeners) {
        if (this.eventListeners == null) {
            this.eventListeners = new HashSet<EurekaEventListener>();
        }
        this.eventListeners.addAll(listeners);
    }

    public void setEventBus(final EventBus eventBus) {
        if (this.eventListeners == null) {
            this.eventListeners = new HashSet<EurekaEventListener>();
        }
        this.eventListeners.add(new EurekaEventListener(){

            @Override
            public void onEvent(EurekaEvent event) {
                eventBus.publish(event);
            }
        });
    }

    public void setHealthCheckCallbackProvider(Provider<HealthCheckCallback> healthCheckCallbackProvider) {
        this.healthCheckCallbackProvider = healthCheckCallbackProvider;
    }

    public void setHealthCheckHandlerProvider(Provider<HealthCheckHandler> healthCheckHandlerProvider) {
        this.healthCheckHandlerProvider = healthCheckHandlerProvider;
    }

    public void setPreRegistrationHandler(PreRegistrationHandler preRegistrationHandler) {
        this.preRegistrationHandler = preRegistrationHandler;
    }

    public void setAdditionalFilters(Collection<T> additionalFilters) {
        this.additionalFilters = additionalFilters;
    }

    public TransportClientFactory getTransportClientFactory() {
        return this.transportClientFactory;
    }

    public void setTransportClientFactory(TransportClientFactory transportClientFactory) {
        this.transportClientFactory = transportClientFactory;
    }

    Set<EurekaEventListener> getEventListeners() {
        return this.eventListeners == null ? Collections.emptySet() : this.eventListeners;
    }

    public Optional<SSLContext> getSSLContext() {
        return this.sslContext;
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = Optional.of(sslContext);
    }

    public Optional<HostnameVerifier> getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = Optional.of(hostnameVerifier);
    }
}

