/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.PrefixedNameSet;
import com.ctc.wstx.util.PrefixedName;

public final class SmallPrefixedNameSet
extends PrefixedNameSet {
    final boolean mNsAware;
    final String[] mStrings;

    public SmallPrefixedNameSet(boolean nsAware, PrefixedName[] names) {
        this.mNsAware = nsAware;
        int len = names.length;
        if (len == 0) {
            throw new IllegalStateException("Trying to construct empty PrefixedNameSet");
        }
        this.mStrings = new String[nsAware ? len + len : len];
        int out = 0;
        for (int in = 0; in < len; ++in) {
            PrefixedName nk = names[in];
            if (nsAware) {
                this.mStrings[out++] = nk.getPrefix();
            }
            this.mStrings[out++] = nk.getLocalName();
        }
    }

    @Override
    public boolean hasMultiple() {
        return this.mStrings.length > 1;
    }

    @Override
    public boolean contains(PrefixedName name) {
        int len = this.mStrings.length;
        String ln = name.getLocalName();
        String[] strs = this.mStrings;
        if (this.mNsAware) {
            String prefix = name.getPrefix();
            if (strs[1] == ln && strs[0] == prefix) {
                return true;
            }
            for (int i2 = 2; i2 < len; i2 += 2) {
                if (strs[i2 + 1] != ln || strs[i2] != prefix) continue;
                return true;
            }
        } else {
            if (strs[0] == ln) {
                return true;
            }
            for (int i3 = 1; i3 < len; ++i3) {
                if (strs[i3] != ln) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void appendNames(StringBuilder sb, String sep) {
        int i2 = 0;
        while (i2 < this.mStrings.length) {
            String prefix;
            if (i2 > 0) {
                sb.append(sep);
            }
            if (this.mNsAware && (prefix = this.mStrings[i2++]) != null) {
                sb.append(prefix);
                sb.append(':');
            }
            sb.append(this.mStrings[i2++]);
        }
    }
}

