package Service.History_Of_Competition_Service;

import configuration.MQConfig;
import models.Competition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import configuration.MQConfig;
import java.util.ArrayList;
import java.util.List;
import lombok.extern.slf4j.Slf4j;


@RestController
@Component
@Slf4j
@RequestMapping("/competitions")
public class CompetitionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetitionController.class);
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    RestTemplate restTemplate;
    List<Competition> competitions = new ArrayList<>();
    @GetMapping("/GetList")
    public List<Competition> getCompetitions() {
        competitions.add(new Competition(0,"English_Premier_League","England"));
        competitions.add(new Competition(1,"Spanish_La_Liga","Spain"));
        return competitions;
    }
    @RequestMapping("/GetStanding/{CompetitionId}")
    public Competition getHistoryEventOfCompetition(@PathVariable("CompetitionId") String CompetitionId){
        Competition result= restTemplate.getForObject("http://season-service/Seasons/GetSeasonsStanding/"+"English_Premier_League",Competition.class);
        return result;
    }
    @RequestMapping("/MQGetStanding/{CompetitionId}")
    public String getHistoryEventOfCompetitionMQ(@PathVariable("CompetitionId") String CompetitionId){
        rabbitTemplate.convertAndSend(MQConfig.EXCHANGE,MQConfig.SEA_REQ_ROUTING_KEY,CompetitionId);
        LOGGER.info(String.format("Queued: Movie with id %s",CompetitionId));
        return "Your request queued in RabbitMQ ...";
    }
    @RabbitListener(queues = MQConfig.MovieInfoRespQueue)
    public void respCompetition(Competition competition){

        log.info(String.format("Received Competition: %s, %s, %s, %s",competition.getId(),competition.getCountryName(),competition.getName(),competition.getSeasonList()));
    }
}
