/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.serviceregistry;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.cloud.client.discovery.event.InstancePreRegisteredEvent;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistration;
import org.springframework.cloud.netflix.eureka.CloudEurekaInstanceConfig;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;

public class EurekaAutoServiceRegistration
implements AutoServiceRegistration,
SmartLifecycle,
Ordered,
SmartApplicationListener {
    private static final Log log = LogFactory.getLog(EurekaAutoServiceRegistration.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final int order = 0;
    private final AtomicInteger port = new AtomicInteger(0);
    private final ApplicationContext context;
    private final EurekaServiceRegistry serviceRegistry;
    private final EurekaRegistration registration;

    public EurekaAutoServiceRegistration(ApplicationContext context, EurekaServiceRegistry serviceRegistry, EurekaRegistration registration) {
        this.context = context;
        this.serviceRegistry = serviceRegistry;
        this.registration = registration;
    }

    @Override
    public void start() {
        if (this.port.get() != 0) {
            if (this.registration.getNonSecurePort() == 0) {
                this.registration.setNonSecurePort(this.port.get());
            }
            if (this.registration.getSecurePort() == 0 && this.registration.isSecure()) {
                this.registration.setSecurePort(this.port.get());
            }
        }
        if (!this.running.get() && this.registration.getNonSecurePort() > 0) {
            this.context.publishEvent(new InstancePreRegisteredEvent((Object)this, this.registration));
            this.serviceRegistry.register(this.registration);
            this.context.publishEvent(new InstanceRegisteredEvent<CloudEurekaInstanceConfig>((Object)this, this.registration.getInstanceConfig()));
            this.running.set(true);
        }
    }

    @Override
    public void stop() {
        this.serviceRegistry.deregister(this.registration);
        this.running.set(false);
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public int getPhase() {
        return 0;
    }

    @Override
    public boolean isAutoStartup() {
        return true;
    }

    @Override
    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return WebServerInitializedEvent.class.isAssignableFrom(eventType) || ContextClosedEvent.class.isAssignableFrom(eventType);
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof WebServerInitializedEvent) {
            this.onApplicationEvent((WebServerInitializedEvent)event);
        } else if (event instanceof ContextClosedEvent) {
            this.onApplicationEvent((ContextClosedEvent)event);
        }
    }

    @Override
    public void onApplicationEvent(WebServerInitializedEvent event) {
        String contextName = event.getApplicationContext().getServerNamespace();
        if (contextName == null || !contextName.equals("management")) {
            int localPort = event.getWebServer().getPort();
            if (this.port.get() == 0) {
                log.info("Updating port to " + localPort);
                this.port.compareAndSet(0, localPort);
                this.start();
            }
        }
    }

    @Override
    public void onApplicationEvent(ContextClosedEvent event) {
        if (event.getApplicationContext() == this.context) {
            this.stop();
        }
    }
}

