/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.http;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.discovery.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.netflix.eureka.http.EurekaApplications;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class RestTemplateEurekaHttpClient
implements EurekaHttpClient {
    private final RestTemplate restTemplate;
    private String serviceUrl;

    public RestTemplateEurekaHttpClient(RestTemplate restTemplate, String serviceUrl) {
        this.restTemplate = restTemplate;
        this.serviceUrl = serviceUrl;
        if (!serviceUrl.endsWith("/")) {
            this.serviceUrl = this.serviceUrl + "/";
        }
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @Override
    public EurekaHttpResponse<Void> register(InstanceInfo info) {
        String urlPath = this.serviceUrl + "apps/" + info.getAppName();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Accept-Encoding", "gzip");
        headers.add("Content-Type", "application/json");
        ResponseEntity<Void> response = this.restTemplate.exchange(urlPath, HttpMethod.POST, new HttpEntity<InstanceInfo>(info, headers), Void.class, new Object[0]);
        return EurekaHttpResponse.anEurekaHttpResponse(response.getStatusCode().value()).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    @Override
    public EurekaHttpResponse<Void> cancel(String appName, String id) {
        String urlPath = this.serviceUrl + "apps/" + appName + "/" + id;
        ResponseEntity<Void> response = this.restTemplate.exchange(urlPath, HttpMethod.DELETE, null, Void.class, new Object[0]);
        return EurekaHttpResponse.anEurekaHttpResponse(response.getStatusCode().value()).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    @Override
    public EurekaHttpResponse<InstanceInfo> sendHeartBeat(String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus overriddenStatus) {
        String urlPath = this.serviceUrl + "apps/" + appName + "/" + id + "?status=" + info.getStatus().toString() + "&lastDirtyTimestamp=" + info.getLastDirtyTimestamp().toString() + (String)(overriddenStatus != null ? "&overriddenstatus=" + overriddenStatus.name() : "");
        ResponseEntity<InstanceInfo> response = this.restTemplate.exchange(urlPath, HttpMethod.PUT, null, InstanceInfo.class, new Object[0]);
        EurekaHttpResponse.EurekaHttpResponseBuilder<Class<InstanceInfo>> eurekaResponseBuilder = EurekaHttpResponse.anEurekaHttpResponse(response.getStatusCode().value(), InstanceInfo.class).headers(RestTemplateEurekaHttpClient.headersOf(response));
        if (response.hasBody()) {
            eurekaResponseBuilder.entity((Class<InstanceInfo>)((Object)((InstanceInfo)response.getBody())));
        }
        return eurekaResponseBuilder.build();
    }

    @Override
    public EurekaHttpResponse<Void> statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, InstanceInfo info) {
        String urlPath = this.serviceUrl + "apps/" + appName + "/" + id + "/status?value=" + newStatus.name() + "&lastDirtyTimestamp=" + info.getLastDirtyTimestamp().toString();
        ResponseEntity<Void> response = this.restTemplate.exchange(urlPath, HttpMethod.PUT, null, Void.class, new Object[0]);
        return EurekaHttpResponse.anEurekaHttpResponse(response.getStatusCode().value()).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    @Override
    public EurekaHttpResponse<Void> deleteStatusOverride(String appName, String id, InstanceInfo info) {
        String urlPath = this.serviceUrl + "apps/" + appName + "/" + id + "/status?lastDirtyTimestamp=" + info.getLastDirtyTimestamp().toString();
        ResponseEntity<Void> response = this.restTemplate.exchange(urlPath, HttpMethod.DELETE, null, Void.class, new Object[0]);
        return EurekaHttpResponse.anEurekaHttpResponse(response.getStatusCode().value()).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    @Override
    public EurekaHttpResponse<Applications> getApplications(String ... regions) {
        return this.getApplicationsInternal("apps/", regions);
    }

    private EurekaHttpResponse<Applications> getApplicationsInternal(String urlPath, String[] regions) {
        String url = this.serviceUrl + urlPath;
        if (regions != null && regions.length > 0) {
            url = url + (urlPath.contains("?") ? "&" : "?") + "regions=" + StringUtil.join(regions);
        }
        ResponseEntity<EurekaApplications> response = this.restTemplate.exchange(url, HttpMethod.GET, null, EurekaApplications.class, new Object[0]);
        return EurekaHttpResponse.anEurekaHttpResponse(response.getStatusCode().value(), response.getStatusCode().value() == HttpStatus.OK.value() && response.hasBody() ? (Applications)response.getBody() : null).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    @Override
    public EurekaHttpResponse<Applications> getDelta(String ... regions) {
        return this.getApplicationsInternal("apps/delta", regions);
    }

    @Override
    public EurekaHttpResponse<Applications> getVip(String vipAddress, String ... regions) {
        return this.getApplicationsInternal("vips/" + vipAddress, regions);
    }

    @Override
    public EurekaHttpResponse<Applications> getSecureVip(String secureVipAddress, String ... regions) {
        return this.getApplicationsInternal("svips/" + secureVipAddress, regions);
    }

    @Override
    public EurekaHttpResponse<Application> getApplication(String appName) {
        String urlPath = this.serviceUrl + "apps/" + appName;
        ResponseEntity<Application> response = this.restTemplate.exchange(urlPath, HttpMethod.GET, null, Application.class, new Object[0]);
        Application application = response.getStatusCode().value() == HttpStatus.OK.value() && response.hasBody() ? (Application)response.getBody() : null;
        return EurekaHttpResponse.anEurekaHttpResponse(response.getStatusCode().value(), application).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    @Override
    public EurekaHttpResponse<InstanceInfo> getInstance(String appName, String id) {
        return this.getInstanceInternal("apps/" + appName + "/" + id);
    }

    @Override
    public EurekaHttpResponse<InstanceInfo> getInstance(String id) {
        return this.getInstanceInternal("instances/" + id);
    }

    private EurekaHttpResponse<InstanceInfo> getInstanceInternal(String urlPath) {
        urlPath = this.serviceUrl + (String)urlPath;
        ResponseEntity<InstanceInfo> response = this.restTemplate.exchange((String)urlPath, HttpMethod.GET, null, InstanceInfo.class, new Object[0]);
        return EurekaHttpResponse.anEurekaHttpResponse(response.getStatusCode().value(), response.getStatusCode().value() == HttpStatus.OK.value() && response.hasBody() ? (InstanceInfo)response.getBody() : null).headers(RestTemplateEurekaHttpClient.headersOf(response)).build();
    }

    @Override
    public void shutdown() {
    }

    private static Map<String, String> headersOf(ResponseEntity<?> response) {
        HttpHeaders httpHeaders = response.getHeaders();
        if (httpHeaders == null || httpHeaders.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : httpHeaders.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            headers.put(entry.getKey(), entry.getValue().get(0));
        }
        return headers;
    }
}

