/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.event.WeightDefinedEvent;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.WeightConfig;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.web.server.ServerWebExchange;

public class WeightRoutePredicateFactory
extends AbstractRoutePredicateFactory<WeightConfig>
implements ApplicationEventPublisherAware {
    public static final String GROUP_KEY = "weight.group";
    public static final String WEIGHT_KEY = "weight.weight";
    private static final Log log = LogFactory.getLog(WeightRoutePredicateFactory.class);
    private ApplicationEventPublisher publisher;

    public WeightRoutePredicateFactory() {
        super(WeightConfig.class);
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(GROUP_KEY, WEIGHT_KEY);
    }

    @Override
    public String shortcutFieldPrefix() {
        return "weight";
    }

    @Override
    public void beforeApply(WeightConfig config) {
        if (this.publisher != null) {
            this.publisher.publishEvent(new WeightDefinedEvent((Object)this, config));
        }
    }

    @Override
    public Predicate<ServerWebExchange> apply(final WeightConfig config) {
        return new GatewayPredicate(){

            @Override
            public boolean test(ServerWebExchange exchange2) {
                Map weights = exchange2.getAttributeOrDefault(ServerWebExchangeUtils.WEIGHT_ATTR, Collections.emptyMap());
                String routeId = (String)exchange2.getAttribute(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR);
                String group = config.getGroup();
                if (weights.containsKey(group)) {
                    String chosenRoute = (String)weights.get(group);
                    if (log.isTraceEnabled()) {
                        log.trace("in group weight: " + group + ", current route: " + routeId + ", chosen route: " + chosenRoute);
                    }
                    return routeId.equals(chosenRoute);
                }
                if (log.isTraceEnabled()) {
                    log.trace("no weights found for group: " + group + ", current route: " + routeId);
                }
                return false;
            }

            @Override
            public Object getConfig() {
                return config;
            }

            public String toString() {
                return String.format("Weight: %s %s", config.getGroup(), config.getWeight());
            }
        };
    }
}

