/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.keygenerator;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.cloud.gateway.filter.factory.cache.keygenerator.KeyValueGenerator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;

class HeaderKeyValueGenerator
implements KeyValueGenerator {
    private final String header;
    private final String valueSeparator;

    HeaderKeyValueGenerator(String header, String valueSeparator) {
        this.valueSeparator = valueSeparator;
        if (!StringUtils.hasText(header)) {
            throw new IllegalArgumentException("The parameter cannot be empty or null");
        }
        this.header = header;
    }

    @Override
    public String getKeyValue(ServerHttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        if (headers.get(this.header) != null) {
            StringBuilder keyVaryHeaders = new StringBuilder();
            keyVaryHeaders.append(this.header).append("=").append(this.getHeaderValues(headers).sorted().collect(Collectors.joining(this.valueSeparator)));
            return keyVaryHeaders.toString();
        }
        return null;
    }

    private Stream<String> getHeaderValues(HttpHeaders headers) {
        Object value = headers.get(this.header);
        return value == null ? Stream.empty() : value.stream();
    }
}

