/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.OrderedGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.web.server.ServerWebExchange;

public abstract class AbstractChangeRequestUriGatewayFilterFactory<T>
extends AbstractGatewayFilterFactory<T> {
    private final int order;

    public AbstractChangeRequestUriGatewayFilterFactory(Class<T> clazz, int order) {
        super(clazz);
        this.order = order;
    }

    public AbstractChangeRequestUriGatewayFilterFactory(Class<T> clazz) {
        this(clazz, 10001);
    }

    protected abstract Optional<URI> determineRequestUri(ServerWebExchange var1, T var2);

    @Override
    public GatewayFilter apply(T config) {
        return new OrderedGatewayFilter((exchange2, chain) -> {
            Optional<URI> uri = this.determineRequestUri(exchange2, config);
            uri.ifPresent(u -> {
                Map<String, Object> attributes = exchange2.getAttributes();
                attributes.put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, u);
            });
            return chain.filter(exchange2);
        }, this.order);
    }
}

