/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebClientWriteResponseFilter
implements GlobalFilter,
Ordered {
    public static final int WRITE_RESPONSE_FILTER_ORDER = -1;
    private static final Log log = LogFactory.getLog(WebClientWriteResponseFilter.class);

    @Override
    public int getOrder() {
        return -1;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
        return chain.filter(exchange2).doOnError(throwable -> this.cleanup(exchange2)).then(Mono.defer(() -> {
            ClientResponse clientResponse = (ClientResponse)exchange2.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_ATTR);
            if (clientResponse == null) {
                return Mono.empty();
            }
            log.trace("WebClientWriteResponseFilter start");
            ServerHttpResponse response = exchange2.getResponse();
            return response.writeWith((Publisher<? extends DataBuffer>)clientResponse.body(BodyExtractors.toDataBuffers())).doOnCancel(() -> this.cleanup(exchange2));
        }));
    }

    private void cleanup(ServerWebExchange exchange2) {
        ClientResponse clientResponse = (ClientResponse)exchange2.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_ATTR);
        if (clientResponse != null) {
            clientResponse.bodyToMono(Void.class).subscribe();
        }
    }
}

