/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.config.HttpClientProperties;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.TimeoutException;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;

public class NettyRoutingFilter
implements GlobalFilter,
Ordered {
    public static final int ORDER = Integer.MAX_VALUE;
    private static final Log log = LogFactory.getLog(NettyRoutingFilter.class);
    private final HttpClient httpClient;
    private final ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider;
    private final HttpClientProperties properties;
    private volatile List<HttpHeadersFilter> headersFilters;

    public NettyRoutingFilter(HttpClient httpClient, ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider, HttpClientProperties properties) {
        this.httpClient = httpClient;
        this.headersFiltersProvider = headersFiltersProvider;
        this.properties = properties;
    }

    public List<HttpHeadersFilter> getHeadersFilters() {
        if (this.headersFilters == null) {
            this.headersFilters = this.headersFiltersProvider.getIfAvailable();
        }
        return this.headersFilters;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
        URI requestUrl = (URI)exchange2.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme();
        if (ServerWebExchangeUtils.isAlreadyRouted(exchange2) || !"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            return chain.filter(exchange2);
        }
        ServerWebExchangeUtils.setAlreadyRouted(exchange2);
        ServerHttpRequest request = exchange2.getRequest();
        HttpMethod method = HttpMethod.valueOf(request.getMethod().name());
        String url = requestUrl.toASCIIString();
        HttpHeaders filtered = HttpHeadersFilter.filterRequest(this.getHeadersFilters(), exchange2);
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        filtered.forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)httpHeaders::set));
        boolean preserveHost = exchange2.getAttributeOrDefault(ServerWebExchangeUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, false);
        Route route = (Route)exchange2.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        Flux responseFlux = this.getHttpClientMono(route, exchange2).flatMapMany(httpClient -> ((HttpClient.RequestSender)httpClient.headers(headers -> {
            headers.add(httpHeaders);
            headers.remove("Host");
            if (preserveHost) {
                String host = request.getHeaders().getFirst("Host");
                headers.add("Host", (Object)host);
            }
        }).request(method).uri(url)).send((req, nettyOutbound) -> {
            if (log.isTraceEnabled()) {
                nettyOutbound.withConnection(connection -> log.trace("outbound route: " + connection.channel().id().asShortText() + ", inbound: " + exchange2.getLogPrefix()));
            }
            return nettyOutbound.send(request.getBody().map(this::getByteBuf));
        }).responseConnection((res, connection) -> {
            exchange2.getAttributes().put(ServerWebExchangeUtils.CLIENT_RESPONSE_ATTR, res);
            exchange2.getAttributes().put(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR, connection);
            ServerHttpResponse response = exchange2.getResponse();
            HttpHeaders headers = new HttpHeaders();
            res.responseHeaders().forEach(entry -> headers.add((String)entry.getKey(), (String)entry.getValue()));
            String contentTypeValue = headers.getFirst("Content-Type");
            if (StringUtils.hasLength(contentTypeValue)) {
                exchange2.getAttributes().put("original_response_content_type", contentTypeValue);
            }
            this.setResponseStatus((HttpClientResponse)res, response);
            HttpHeaders filteredResponseHeaders = HttpHeadersFilter.filter(this.getHeadersFilters(), headers, exchange2, HttpHeadersFilter.Type.RESPONSE);
            if (!filteredResponseHeaders.containsKey("Transfer-Encoding") && filteredResponseHeaders.containsKey("Content-Length")) {
                response.getHeaders().remove("Transfer-Encoding");
            }
            exchange2.getAttributes().put(ServerWebExchangeUtils.CLIENT_RESPONSE_HEADER_NAMES, filteredResponseHeaders.keySet());
            response.getHeaders().addAll(filteredResponseHeaders);
            return Mono.just(res);
        }));
        Duration responseTimeout = this.getResponseTimeout(route);
        if (responseTimeout != null) {
            responseFlux = responseFlux.timeout(responseTimeout, Mono.error(new TimeoutException("Response took longer than timeout: " + responseTimeout))).onErrorMap(TimeoutException.class, th -> new ResponseStatusException((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT, th.getMessage(), (Throwable)th));
        }
        return responseFlux.then(chain.filter(exchange2));
    }

    protected ByteBuf getByteBuf(DataBuffer dataBuffer) {
        if (dataBuffer instanceof NettyDataBuffer) {
            NettyDataBuffer buffer = (NettyDataBuffer)dataBuffer;
            return buffer.getNativeBuffer();
        }
        if (dataBuffer instanceof DefaultDataBuffer) {
            DefaultDataBuffer buffer = (DefaultDataBuffer)dataBuffer;
            return Unpooled.wrappedBuffer(buffer.getNativeBuffer());
        }
        throw new IllegalArgumentException("Unable to handle DataBuffer of type " + dataBuffer.getClass());
    }

    private void setResponseStatus(HttpClientResponse clientResponse, ServerHttpResponse response) {
        HttpStatus status = HttpStatus.resolve(clientResponse.status().code());
        if (status != null) {
            response.setStatusCode(status);
        } else {
            while (response instanceof ServerHttpResponseDecorator) {
                response = ((ServerHttpResponseDecorator)response).getDelegate();
            }
            if (response instanceof AbstractServerHttpResponse) {
                ((AbstractServerHttpResponse)response).setRawStatusCode(clientResponse.status().code());
            } else {
                throw new IllegalStateException("Unable to set status code " + clientResponse.status().code() + " on response of type " + response.getClass().getName());
            }
        }
    }

    protected Mono<HttpClient> getHttpClientMono(Route route, ServerWebExchange exchange2) {
        return Mono.just(this.getHttpClient(route, exchange2));
    }

    protected HttpClient getHttpClient(Route route, ServerWebExchange exchange2) {
        Object connectTimeoutAttr = route.getMetadata().get("connect-timeout");
        if (connectTimeoutAttr != null) {
            Integer connectTimeout = NettyRoutingFilter.getInteger(connectTimeoutAttr);
            return (HttpClient)this.httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, connectTimeout);
        }
        return this.httpClient;
    }

    static Integer getInteger(Object connectTimeoutAttr) {
        Integer connectTimeout = connectTimeoutAttr instanceof Integer ? (Integer)connectTimeoutAttr : Integer.valueOf(Integer.parseInt(connectTimeoutAttr.toString()));
        return connectTimeout;
    }

    private Duration getResponseTimeout(Route route) {
        try {
            if (route.getMetadata().containsKey("response-timeout")) {
                Long routeResponseTimeout = NettyRoutingFilter.getLong(route.getMetadata().get("response-timeout"));
                if (routeResponseTimeout != null && routeResponseTimeout >= 0L) {
                    return Duration.ofMillis(routeResponseTimeout);
                }
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.properties.getResponseTimeout();
    }

    static Long getLong(Object responseTimeoutAttr) {
        Long responseTimeout = null;
        if (responseTimeoutAttr instanceof Number) {
            responseTimeout = ((Number)responseTimeoutAttr).longValue();
        } else if (responseTimeoutAttr != null) {
            responseTimeout = Long.parseLong(responseTimeoutAttr.toString());
        }
        return responseTimeout;
    }
}

