/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.tagsprovider.GatewayTagsProvider;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GatewayMetricsFilter
implements GlobalFilter,
Ordered {
    private static final Log log = LogFactory.getLog(GatewayMetricsFilter.class);
    private final MeterRegistry meterRegistry;
    private GatewayTagsProvider compositeTagsProvider;
    private final String metricsPrefix;

    public GatewayMetricsFilter(MeterRegistry meterRegistry, List<GatewayTagsProvider> tagsProviders, String metricsPrefix) {
        this.meterRegistry = meterRegistry;
        this.compositeTagsProvider = tagsProviders.stream().reduce(exchange2 -> Tags.empty(), GatewayTagsProvider::and);
        this.metricsPrefix = metricsPrefix.endsWith(".") ? metricsPrefix.substring(0, metricsPrefix.length() - 1) : metricsPrefix;
    }

    public String getMetricsPrefix() {
        return this.metricsPrefix;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
        Timer.Sample sample = Timer.start(this.meterRegistry);
        return chain.filter(exchange2).doOnSuccess(aVoid -> this.endTimerRespectingCommit(exchange2, sample)).doOnError(throwable -> this.endTimerRespectingCommit(exchange2, sample));
    }

    private void endTimerRespectingCommit(ServerWebExchange exchange2, Timer.Sample sample) {
        ServerHttpResponse response = exchange2.getResponse();
        if (response.isCommitted()) {
            this.endTimerInner(exchange2, sample);
        } else {
            response.beforeCommit(() -> {
                this.endTimerInner(exchange2, sample);
                return Mono.empty();
            });
        }
    }

    private void endTimerInner(ServerWebExchange exchange2, Timer.Sample sample) {
        Tags tags = (Tags)this.compositeTagsProvider.apply(exchange2);
        if (log.isTraceEnabled()) {
            log.trace(this.metricsPrefix + ".requests tags: " + tags);
        }
        sample.stop(this.meterRegistry.timer(this.metricsPrefix + ".requests", tags));
    }
}

