/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.cloud.gateway.event.EnableBodyCachingEvent;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class AdaptCachedBodyGlobalFilter
implements GlobalFilter,
Ordered,
ApplicationListener<EnableBodyCachingEvent> {
    private ConcurrentMap<String, Boolean> routesToCache = new ConcurrentHashMap<String, Boolean>();

    @Override
    public void onApplicationEvent(EnableBodyCachingEvent event) {
        this.routesToCache.putIfAbsent(event.getRouteId(), true);
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, GatewayFilterChain chain) {
        ServerHttpRequest cachedRequest = exchange2.getAttributeOrDefault("cachedServerHttpRequestDecorator", null);
        if (cachedRequest != null) {
            exchange2.getAttributes().remove("cachedServerHttpRequestDecorator");
            return chain.filter(exchange2.mutate().request(cachedRequest).build());
        }
        DataBuffer body2 = exchange2.getAttributeOrDefault("cachedRequestBody", null);
        Route route = (Route)exchange2.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
        if (body2 != null || !this.routesToCache.containsKey(route.getId())) {
            return chain.filter(exchange2);
        }
        return ServerWebExchangeUtils.cacheRequestBody(exchange2, serverHttpRequest -> {
            if (serverHttpRequest == exchange2.getRequest()) {
                return chain.filter(exchange2);
            }
            return chain.filter(exchange2.mutate().request((ServerHttpRequest)serverHttpRequest).build());
        });
    }

    @Override
    public int getOrder() {
        return -2147482648;
    }
}

